/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.common;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;

public class DiffViewerVariablesPanel
extends AbstractDialogPanel {
    protected List variablesList;
    protected Text variableDescription;
    protected Map<String, String> variablesMap = new LinkedHashMap<String, String>();
    protected String variable;

    public DiffViewerVariablesPanel() {
        this.dialogTitle = SVNUIMessages.DiffViewerVariablesPanel_DialogTitle;
        this.dialogDescription = SVNUIMessages.DiffViewerVariablesPanel_DialogDescription;
        this.defaultMessage = SVNUIMessages.DiffViewerVariablesPanel_DialogDefaultMessage;
        this.variablesMap.put("base", SVNUIMessages.DiffViewerVariablesPanel_BaseVariable_Description);
        this.variablesMap.put("mine", SVNUIMessages.DiffViewerVariablesPanel_MineVariable_Description);
        this.variablesMap.put("theirs", SVNUIMessages.DiffViewerVariablesPanel_TheirsVariable_Description);
        this.variablesMap.put("merged", SVNUIMessages.DiffViewerVariablesPanel_MergedVariable_Description);
        this.variablesMap.put("default-doc-program", BaseMessages.format((String)SVNUIMessages.DiffViewerVariablesPanel_DefaultVariable_Description, (Object)SVNUIMessages.DiffViewerVariablesPanel_DefaultDocVariable_Program));
        this.variablesMap.put("default-xls-program", BaseMessages.format((String)SVNUIMessages.DiffViewerVariablesPanel_DefaultVariable_Description, (Object)SVNUIMessages.DiffViewerVariablesPanel_DefaultXlsVariable_Program));
        this.variablesMap.put("default-ppt-program", BaseMessages.format((String)SVNUIMessages.DiffViewerVariablesPanel_DefaultVariable_Description, (Object)SVNUIMessages.DiffViewerVariablesPanel_DefaultPptVariable_Program));
        this.variablesMap.put("default-odt-program", BaseMessages.format((String)SVNUIMessages.DiffViewerVariablesPanel_DefaultVariable_Description, (Object)SVNUIMessages.DiffViewerVariablesPanel_DefaultOdtVariable_Program));
        this.variablesMap.put("default-ods-program", BaseMessages.format((String)SVNUIMessages.DiffViewerVariablesPanel_DefaultVariable_Description, (Object)SVNUIMessages.DiffViewerVariablesPanel_DefaultOdsVariable_Program));
    }

    @Override
    protected void createControlsImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        GridData data = new GridData(1808);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        this.variablesList = new List(composite, 2820);
        data = new GridData(1808);
        data.heightHint = DefaultDialog.convertHeightInCharsToPixels((Control)this.variablesList, 10);
        this.variablesList.setLayoutData((Object)data);
        Label variableDescriptionLabel = new Label(composite, 0);
        data = new GridData();
        variableDescriptionLabel.setLayoutData((Object)data);
        variableDescriptionLabel.setText(SVNUIMessages.DiffViewerVariablesPanel_VariableDescriptionLabel);
        this.variableDescription = new Text(composite, 2882);
        data = new GridData(768);
        data.heightHint = DefaultDialog.convertHeightInCharsToPixels((Control)this.variableDescription, 4);
        this.variableDescription.setLayoutData((Object)data);
        this.variableDescription.setBackground(this.variableDescription.getBackground());
        this.variableDescription.setEditable(false);
        this.variablesList.addListener(13, event -> {
            String variableName = this.getSelectedVariable();
            if (variableName != null) {
                this.variableDescription.setText(this.variablesMap.get(variableName));
                this.validateContent();
            }
        });
        this.initializeControls();
    }

    protected String getSelectedVariable() {
        String variable = null;
        String[] selected = this.variablesList.getSelection();
        if (selected.length > 0) {
            variable = selected[0];
        }
        return variable;
    }

    protected void initializeControls() {
        String firstVariable = null;
        for (String variableName : this.variablesMap.keySet()) {
            this.variablesList.add(variableName);
            if (firstVariable != null) continue;
            firstVariable = variableName;
        }
        this.variablesList.select(0);
        this.variableDescription.setText(this.variablesMap.get(firstVariable));
    }

    @Override
    protected void saveChangesImpl() {
        String var = this.getSelectedVariable();
        this.variable = var != null ? "\"${" + var + "}\"" : "";
    }

    @Override
    protected void cancelChangesImpl() {
        this.variable = null;
    }

    public String getVariable() {
        return this.variable;
    }
}

