/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import java.util.HashSet;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.operation.SVNResourceRuleFactory;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.DiffViewerSettings;
import org.eclipse.team.svn.core.operation.local.RunExternalCompareOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.compare.ComparePanel;
import org.eclipse.team.svn.ui.compare.ConflictingFileEditorInput;
import org.eclipse.team.svn.ui.compare.ThreeWayPropertyCompareInput;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.preferences.SVNTeamDiffViewerPage;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class ShowConflictEditorOperation
extends AbstractWorkingCopyOperation {
    protected boolean showInDialog;

    public ShowConflictEditorOperation(IResource[] resources, boolean showInDialog) {
        super("Operation_ShowConflictEditor", SVNUIMessages.class, resources);
        this.showInDialog = showInDialog;
    }

    public ShowConflictEditorOperation(IResourceProvider provider, boolean showInDialog) {
        super("Operation_ShowConflictEditor", SVNUIMessages.class, provider);
        this.showInDialog = showInDialog;
    }

    public ISchedulingRule getSchedulingRule() {
        ISchedulingRule rule = super.getSchedulingRule();
        if (rule instanceof IWorkspaceRoot) {
            return rule;
        }
        IResource[] resources = this.operableData();
        HashSet<ISchedulingRule> ruleSet = new HashSet<ISchedulingRule>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            ruleSet.add(SVNResourceRuleFactory.INSTANCE.refreshRule((IResource)element.getParent()));
            ++n2;
        }
        return new MultiRule((ISchedulingRule[])ruleSet.toArray(new IResource[ruleSet.size()]));
    }

    public int getOperationWeight() {
        return 0;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] conflictingResources = this.operableData();
        int i = 0;
        while (i < conflictingResources.length && !monitor.isCanceled()) {
            IResource current = conflictingResources[i];
            this.protectStep(monitor1 -> this.showEditorFor(current, monitor1), monitor, conflictingResources.length);
            ++i;
        }
    }

    protected void showEditorFor(IResource resource, IProgressMonitor monitor) throws Exception {
        SVNChangeStatus[] status;
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IRepositoryLocation location = storage.getRepositoryLocation(resource);
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            status = SVNUtility.status((ISVNConnector)proxy, (String)FileUtility.getWorkingCopyPath((IResource)resource), (SVNDepth)SVNDepth.EMPTY, (long)0L, (ISVNProgressMonitor)new SVNNullProgressMonitor());
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
        if (status.length == 1 && status[0].propStatus == SVNEntryStatus.Kind.CONFLICTED) {
            CompareConfiguration cc = new CompareConfiguration();
            cc.setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (Object)Boolean.TRUE);
            ILocalResource baseResource = SVNRemoteStorage.instance().asLocalResource(resource);
            IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(resource);
            SVNEntryRevisionReference baseReference = new SVNEntryRevisionReference(FileUtility.getWorkingCopyPath((IResource)resource), null, SVNRevision.BASE);
            ThreeWayPropertyCompareInput compare = new ThreeWayPropertyCompareInput(cc, resource, null, baseReference, remote.getRepositoryLocation(), baseResource.getRevision());
            compare.run(monitor);
            UIMonitorUtility.getDisplay().syncExec(() -> {
                if (this.showInDialog) {
                    ComparePanel panel = new ComparePanel(compare, resource);
                    DefaultDialog dlg = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                    dlg.open();
                } else {
                    CompareUI.openCompareEditor((CompareEditorInput)compare);
                }
            });
        }
        if (resource.getType() == 1 && status.length == 1 && status[0].hasConflict && status[0].treeConflicts != null && status[0].treeConflicts[0].remotePath != null && status[0].treeConflicts[0].basePath != null) {
            IContainer parent = resource.getParent();
            parent.refreshLocal(1, monitor);
            IFile local = null;
            Path tPath = null;
            if (status[0].treeConflicts[0].localPath != null && !"".equals(status[0].treeConflicts[0].localPath) && !(local = parent.getFile((tPath = new Path(status[0].treeConflicts[0].localPath)).removeFirstSegments(tPath.segmentCount() - 1))).exists()) {
                local = null;
            }
            local = local == null ? (IFile)resource : local;
            tPath = new Path(status[0].treeConflicts[0].remotePath);
            IFile remote = parent.getFile(tPath.removeFirstSegments(tPath.segmentCount() - 1));
            tPath = new Path(status[0].treeConflicts[0].basePath);
            IFile ancestor = parent.getFile(tPath.removeFirstSegments(tPath.segmentCount() - 1));
            RunExternalCompareOperation.DetectExternalCompareOperationHelper detectCompareEditorHelper = new RunExternalCompareOperation.DetectExternalCompareOperationHelper(resource, SVNTeamDiffViewerPage.loadDiffViewerSettings(), false);
            detectCompareEditorHelper.execute(monitor);
            DiffViewerSettings.ExternalProgramParameters externalProgramParams = detectCompareEditorHelper.getExternalProgramParameters();
            if (externalProgramParams != null) {
                this.openExternalEditor((IFile)resource, local, remote, ancestor, externalProgramParams, monitor);
            } else {
                this.openEclipseEditor((IFile)resource, local, remote, ancestor, monitor);
            }
        }
    }

    protected void openExternalEditor(IFile target, IFile left, IFile right, IFile ancestor, DiffViewerSettings.ExternalProgramParameters externalProgramParams, IProgressMonitor monitor) throws Exception {
        String targetFile = FileUtility.getWorkingCopyPath((IResource)target);
        String oldFile = FileUtility.getWorkingCopyPath((IResource)ancestor);
        String workingFile = FileUtility.getWorkingCopyPath((IResource)left);
        String newFile = FileUtility.getWorkingCopyPath((IResource)right);
        RunExternalCompareOperation.ExternalCompareOperationHelper compareRunner = new RunExternalCompareOperation.ExternalCompareOperationHelper(oldFile, workingFile, newFile, targetFile, externalProgramParams, false);
        compareRunner.execute(monitor);
    }

    protected void openEclipseEditor(IFile target, IFile left, IFile right, IFile ancestor, IProgressMonitor monitor) throws Exception {
        CompareConfiguration cc = new CompareConfiguration();
        cc.setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (Object)Boolean.TRUE);
        ConflictingFileEditorInput compare = new ConflictingFileEditorInput(cc, target, left, right, ancestor);
        compare.run(monitor);
        UIMonitorUtility.getDisplay().syncExec(() -> {
            if (this.showInDialog) {
                ComparePanel panel = new ComparePanel(compare, (IResource)target);
                DefaultDialog dlg = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                dlg.open();
            } else {
                CompareUI.openCompareEditor((CompareEditorInput)compare);
            }
            compare.setDirty(true);
        });
    }
}

