/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.decorator;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.team.svn.ui.decorator.IVariable;
import org.eclipse.team.svn.ui.decorator.IVariableContentProvider;
import org.eclipse.team.svn.ui.decorator.IVariableSetProvider;
import org.eclipse.team.svn.ui.decorator.UserVariable;

public final class DecoratorVariables {
    protected IVariableSetProvider variableSetProvider;

    private String getValue(IVariable var, IVariableContentProvider provider) {
        return this.amend(var, provider);
    }

    private String amend(IVariable var, IVariableContentProvider provider) {
        IVariable[] variables = this.parseFormatLine(provider.getValue(var));
        Object value = "";
        IVariable[] iVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable variable = iVariableArray[n2];
            String variableValue = provider.getValue(variable);
            value = !variable.equals(var) ? (String)value + variableValue : (variableValue.equals(variable.getName()) ? (String)value + variableValue : (String)value + "?{" + variable.getName() + "}?");
            ++n2;
        }
        return value;
    }

    public void decorateText(IDecoration decoration, IVariable[] format, IVariableContentProvider provider) {
        int centerPoint = Arrays.asList(format).indexOf(this.variableSetProvider.getCenterVariable());
        Object prefix = "";
        Object suffix = "";
        int i = 0;
        while (i < format.length) {
            if (!format[i].equals(this.variableSetProvider.getCenterVariable())) {
                if (centerPoint != -1 && i < centerPoint) {
                    prefix = (String)prefix + this.getValue(format[i], provider);
                } else {
                    suffix = (String)suffix + this.getValue(format[i], provider);
                }
            }
            ++i;
        }
        i = 0;
        while (i < ((String)prefix).length() && Character.isWhitespace(((String)prefix).charAt(i))) {
            ++i;
        }
        prefix = ((String)prefix).substring(i);
        i = ((String)suffix).length() - 1;
        while (i >= 0 && Character.isWhitespace(((String)suffix).charAt(i))) {
            --i;
        }
        suffix = ((String)suffix).substring(0, i + 1);
        decoration.addPrefix((String)prefix);
        decoration.addSuffix((String)suffix);
    }

    public static String prepareFormatLine(IVariable[] format) {
        Object retVal = "";
        IVariable[] iVariableArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable element = iVariableArray[n2];
            retVal = element instanceof UserVariable ? (String)retVal + element.getName() : (String)retVal + "{" + element.getName() + "}";
            ++n2;
        }
        return retVal;
    }

    public IVariable[] parseFormatLine(String line) {
        ArrayList<IVariable> retVal = new ArrayList<IVariable>();
        int startPos = 0;
        int stopPos = -1;
        int state = 0;
        do {
            switch (state) {
                case 0: {
                    String userData;
                    stopPos = line.indexOf(123, startPos);
                    String string = userData = stopPos != -1 ? line.substring(startPos, stopPos++) : line.substring(startPos);
                    if (userData.length() > 0) {
                        retVal.add(new UserVariable(this.variableSetProvider.getDomainName(), userData));
                    }
                    startPos = stopPos;
                    state = 1;
                    break;
                }
                case 1: {
                    String userData;
                    stopPos = line.indexOf(125, startPos);
                    if (stopPos != -1) {
                        String varName;
                        if ((varName = line.substring(startPos, stopPos++)).length() > 0) {
                            IVariable var = this.variableSetProvider.getVariable(varName);
                            retVal.add(var == null ? new UserVariable(this.variableSetProvider.getDomainName(), varName) : var);
                        }
                    } else {
                        userData = line.substring(startPos);
                        if (userData.length() > 0) {
                            retVal.add(new UserVariable(this.variableSetProvider.getDomainName(), userData));
                        }
                    }
                    startPos = stopPos;
                    state = 0;
                }
            }
        } while (stopPos > 0);
        return retVal.toArray(new IVariable[retVal.size()]);
    }

    public DecoratorVariables(IVariableSetProvider variableSetProvider) {
        this.variableSetProvider = variableSetProvider;
    }
}

