/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.update.action;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.AddToSVNIgnoreOperation;
import org.eclipse.team.svn.core.operation.local.AddToSVNOperation;
import org.eclipse.team.svn.core.operation.local.ClearLocalStatusesOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.synchronize.UpdateSyncInfo;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.panel.local.AbstractResourceSelectionPanel;
import org.eclipse.team.svn.ui.panel.local.AddToSVNPanel;
import org.eclipse.team.svn.ui.panel.local.IgnoreMethodPanel;
import org.eclipse.team.svn.ui.synchronize.action.AbstractActionHelper;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class AddToSVNIgnoreActionHelper
extends AbstractActionHelper {
    protected static IStateFilter SF_NEW_AND_PARENT_VERSIONED = new IStateFilter.AbstractStateFilter(){

        protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
            if (state == "New") {
                return IStateFilter.SF_VERSIONED.accept(SVNRemoteStorage.instance().asLocalResource((IResource)resource.getParent()));
            }
            return false;
        }

        protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
            return true;
        }
    };

    public AddToSVNIgnoreActionHelper(IAction action, ISynchronizePageConfiguration configuration) {
        super(action, configuration);
    }

    @Override
    public FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                UpdateSyncInfo sync = (UpdateSyncInfo)info;
                return SF_NEW_AND_PARENT_VERSIONED.accept(sync.getLocalResource());
            }
        };
    }

    @Override
    public IActionOperation getOperation() {
        AbstractDialogPanel panel;
        IResource[] resources = FileUtility.shrinkChildNodes((IResource[])this.getSyncInfoSelector().getSelectedResources());
        IResource[] operableParents = FileUtility.getOperableParents((IResource[])resources, (IStateFilter)IStateFilter.SF_UNVERSIONED);
        if (operableParents.length > 0) {
            panel = new AddToSVNPanel(operableParents);
            DefaultDialog dialog1 = new DefaultDialog(this.configuration.getSite().getShell(), panel);
            if (dialog1.open() != 0) {
                return null;
            }
            operableParents = ((AbstractResourceSelectionPanel)panel).getSelectedResources();
        }
        panel = new IgnoreMethodPanel(resources);
        DefaultDialog dialog = new DefaultDialog(this.configuration.getSite().getShell(), panel);
        if (dialog.open() != 0) {
            return null;
        }
        AddToSVNIgnoreOperation mainOp = new AddToSVNIgnoreOperation(resources, ((IgnoreMethodPanel)panel).getIgnoreType(), ((IgnoreMethodPanel)panel).getIgnorePattern());
        CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
        if (operableParents.length > 0) {
            op.add((IActionOperation)new AddToSVNOperation(operableParents));
            op.add((IActionOperation)new ClearLocalStatusesOperation(operableParents));
        }
        op.add((IActionOperation)mainOp);
        HashSet<IResource> tmp = new HashSet<IResource>(Arrays.asList(resources));
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            tmp.add((IResource)element.getParent());
            ++n2;
        }
        IResource[] resourcesAndParents = tmp.toArray(new IResource[tmp.size()]);
        op.add((IActionOperation)new RefreshResourcesOperation(resourcesAndParents, 2, RefreshResourcesOperation.REFRESH_ALL));
        return op;
    }
}

