/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.eclipse.team.svn.ui.synchronize.action.ShowHistoryActionHelper;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ShowHistoryAction
extends AbstractSynchronizeModelAction {
    protected ShowHistoryActionHelper actionHelper;

    public ShowHistoryAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
        this.actionHelper = new ShowHistoryActionHelper((IAction)this, configuration);
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        super.updateSelection(selection);
        if (selection.size() == 1) {
            AbstractSVNSyncInfo syncInfo;
            ILocalResource incoming;
            if (selection.getFirstElement() instanceof SyncInfoModelElement && (incoming = (syncInfo = (AbstractSVNSyncInfo)((SyncInfoModelElement)selection.getFirstElement()).getSyncInfo()).getRemoteChangeResource()) instanceof IResourceChange) {
                return IStateFilter.SF_TREE_CONFLICTING.accept(incoming) ? IStateFilter.SF_TREE_CONFLICTING_REPOSITORY_EXIST.accept(incoming) : "Deleted" != incoming.getStatus();
            }
            if (selection.getFirstElement() instanceof ISynchronizeModelElement) {
                ISynchronizeModelElement element = (ISynchronizeModelElement)selection.getFirstElement();
                return IStateFilter.SF_ONREPOSITORY.accept(SVNRemoteStorage.instance().asLocalResource(element.getResource()));
            }
        }
        return false;
    }

    @Override
    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        return this.actionHelper.getOperation();
    }
}

