/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.refactor.DeleteResourceOperation;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.dialog.DiscardConfirmationDialog;
import org.eclipse.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class DeletePaneAction
extends AbstractSynchronizeModelAction {
    public DeletePaneAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    @Override
    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        IResource[] selectedResources = this.getAllSelectedResources();
        DiscardConfirmationDialog dialog = new DiscardConfirmationDialog(UIMonitorUtility.getShell(), selectedResources.length == 1, 2);
        if (dialog.open() == 0) {
            DeleteResourceOperation deleteOperation = new DeleteResourceOperation(selectedResources);
            CompositeOperation op = new CompositeOperation(deleteOperation.getId(), deleteOperation.getMessagesClass());
            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(selectedResources);
            RestoreProjectMetaOperation restoreOp = new RestoreProjectMetaOperation(saveOp);
            op.add((IActionOperation)saveOp);
            op.add((IActionOperation)deleteOperation);
            op.add((IActionOperation)restoreOp);
            op.add((IActionOperation)new RefreshResourcesOperation(selectedResources, 2, RefreshResourcesOperation.REFRESH_CHANGES));
            return op;
        }
        return null;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (super.updateSelection(selection) && selection.size() > 0) {
            IResource[] selectedResources = this.getAllSelectedResources();
            return !FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_DELETED, (int)0);
        }
        return false;
    }
}

