/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.repository.model;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRevisionLink;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.repository.model.IDataTreeNode;
import org.eclipse.team.svn.ui.repository.model.IParentTreeNode;
import org.eclipse.team.svn.ui.repository.model.IToolTipProvider;
import org.eclipse.team.svn.ui.repository.model.RepositoryFictiveNode;
import org.eclipse.team.svn.ui.repository.model.RepositoryFolder;
import org.eclipse.team.svn.ui.repository.model.RepositoryResource;
import org.eclipse.team.svn.ui.repository.model.RepositoryRevisions;
import org.eclipse.ui.PlatformUI;

public class RepositoryRevision
extends RepositoryFictiveNode
implements IParentTreeNode,
IDataTreeNode,
IToolTipProvider {
    protected RepositoryRevisions parent;
    protected RepositoryResource[] wrappers;
    protected IRevisionLink link;
    protected SVNRevision revision;

    public RepositoryRevision(RepositoryRevisions parent, IRevisionLink link) {
        this.parent = parent;
        this.link = link;
        this.revision = this.link.getRepositoryResource().getSelectedRevision();
        this.refresh();
    }

    @Override
    public RGB getForeground(Object element) {
        return RepositoryResource.NOT_RELATED_NODES_FOREGROUND;
    }

    @Override
    public RGB getBackground(Object element) {
        return RepositoryResource.NOT_RELATED_NODES_BACKGROUND;
    }

    @Override
    public FontData getFont(Object element) {
        return RepositoryResource.NOT_RELATED_NODES_FONT.getFontData()[0];
    }

    public SVNRevision getRevision() {
        return this.revision;
    }

    public IRevisionLink getRevisionLink() {
        return this.link;
    }

    @Override
    public void refresh() {
        this.wrappers = RepositoryFolder.wrapChildren(null, new IRepositoryResource[]{this.link.getRepositoryResource()}, null);
    }

    @Override
    public Object getData() {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    public String getLabel() {
        IPath resourcePath;
        IRepositoryResource resource = this.link.getRepositoryResource();
        IPath rootPath = SVNUtility.createPathForSVNUrl((String)this.parent.getRepositoryLocation().getRepositoryRootUrl());
        if (rootPath.isPrefixOf(resourcePath = SVNUtility.createPathForSVNUrl((String)resource.getUrl()))) {
            IPath relativePath = resourcePath.makeRelativeTo(rootPath);
            return "^" + (String)(relativePath.isEmpty() ? "" : "/" + relativePath.toString());
        }
        return resourcePath.toString();
    }

    public String getLabel(Object o) {
        return this.getLabel() + " " + this.revision.toString();
    }

    public Object[] getChildren(Object o) {
        return this.wrappers;
    }

    public ImageDescriptor getImageDescriptor(Object o) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof RepositoryRevision) {
            RepositoryRevision other = (RepositoryRevision)obj;
            return this.revision.equals((Object)other.revision);
        }
        return super.equals(obj);
    }

    @Override
    public String getToolTipMessage(String formatString) {
        return this.link.getComment();
    }
}

