/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.repository.browser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNLock;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.repository.browser.RepositoryBrowserTableViewer;
import org.eclipse.team.svn.ui.repository.model.RepositoryFictiveNode;
import org.eclipse.team.svn.ui.repository.model.RepositoryFictiveWorkingDirectory;
import org.eclipse.team.svn.ui.repository.model.RepositoryResource;
import org.eclipse.team.svn.ui.utility.DateFormatter;

public class RepositoryBrowserLabelProvider
implements ITableLabelProvider {
    protected Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();
    protected static String hasProps;
    protected static String noAuthor;
    protected static String noDate;

    public RepositoryBrowserLabelProvider(RepositoryBrowserTableViewer tableViewer) {
        noAuthor = SVNMessages.SVNInfo_NoAuthor;
        noDate = SVNMessages.SVNInfo_NoDate;
        hasProps = SVNUIMessages.RepositoriesView_Browser_HasProps;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            ImageDescriptor iDescr = null;
            if (element instanceof RepositoryResource) {
                iDescr = ((RepositoryResource)element).getImageDescriptor(null);
            } else if (element instanceof RepositoryFictiveNode) {
                iDescr = ((RepositoryFictiveNode)element).getImageDescriptor(null);
            }
            if (iDescr != null) {
                Image img = this.images.get(iDescr);
                if (img == null) {
                    img = iDescr.createImage();
                    this.images.put(iDescr, img);
                }
                return img;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof RepositoryResource) {
            return this.getColumnTextForElement(element, columnIndex);
        }
        if (element instanceof RepositoryFictiveNode) {
            if (columnIndex == 0) {
                return ((RepositoryFictiveNode)element).getLabel(null);
            }
            if (element instanceof RepositoryFictiveWorkingDirectory) {
                return this.getColumnTextForElement(((RepositoryFictiveWorkingDirectory)element).getAssociatedDirectory(), columnIndex);
            }
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        for (Image img : this.images.values()) {
            img.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    protected String getColumnTextForElement(Object element, int columnIndex) {
        if (element instanceof RepositoryResource) {
            IRepositoryResource resource = ((RepositoryResource)element).getRepositoryResource();
            IRepositoryResource.Information resourceInfo = resource.getInfo();
            if (columnIndex == 0) {
                return ((RepositoryResource)element).getLabel();
            }
            if (columnIndex == 1) {
                String revision = "";
                try {
                    revision = resource.isInfoCached() ? String.valueOf(((RepositoryResource)element).getRevision()) : SVNUIMessages.getString("RepositoriesView_Model_Pending");
                }
                catch (Exception ex) {
                    LoggedOperation.reportError((String)SVNUIMessages.Error_GetColumnText, (Throwable)ex);
                }
                return revision;
            }
            if (resourceInfo != null) {
                if (columnIndex == 2) {
                    return resourceInfo.lastChangedDate != 0L ? DateFormatter.formatDate(resourceInfo.lastChangedDate) : noDate;
                }
                if (columnIndex == 3) {
                    String author = resourceInfo.lastAuthor;
                    return author != null ? author : noAuthor;
                }
                if (columnIndex == 6) {
                    SVNLock lock = resourceInfo.lock;
                    String lockOwner = lock == null ? "" : lock.owner;
                    return lockOwner;
                }
                if (columnIndex == 4) {
                    long size = resourceInfo.fileSize;
                    return resource instanceof IRepositoryFile ? String.valueOf(size) : "";
                }
                if (columnIndex == 5) {
                    boolean hasProps = resourceInfo.hasProperties;
                    return hasProps ? RepositoryBrowserLabelProvider.hasProps : "";
                }
            }
        }
        return "";
    }
}

