/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.participant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeEvent;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeListener;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.core.subscribers.WorkingSetFilteredSyncInfoCollector;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SubscriberParticipantPage;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.panel.participant.BasePaneParticipant;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ParticipantPagePane;

public class PaneParticipantHelper {
    protected boolean isParticipantPane;
    protected BasePaneParticipant participant;
    protected ISynchronizePageConfiguration syncPageConfiguration;
    protected ParticipantPagePane pagePane;
    protected List<IResource> resourcesRemovedFromPane = new ArrayList<IResource>();
    protected ISyncInfoSetChangeListener paneSyncInfoSetListener;

    public PaneParticipantHelper() {
        this.isParticipantPane = PaneParticipantHelper.isParticipantPaneOption();
    }

    public void init(BasePaneParticipant participant) {
        this.participant = participant;
        this.syncPageConfiguration = this.participant.createPageConfiguration();
    }

    public void initListeners() {
        SyncInfoSet paneSyncInfoSet = this.getPaneSyncInfoSet();
        this.paneSyncInfoSetListener = new PaneSyncInfoSetListener();
        paneSyncInfoSet.addSyncSetChangedListener(this.paneSyncInfoSetListener);
    }

    public boolean isParticipantPane() {
        return this.isParticipantPane;
    }

    public static boolean isParticipantPaneOption() {
        return SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "resourceSelection.showResourcesInSyncPane");
    }

    public ISynchronizePageConfiguration getSyncPageConfiguration() {
        return this.syncPageConfiguration;
    }

    public BasePaneParticipant getParticipant() {
        return this.participant;
    }

    public IResource[] getSelectedResources() {
        SyncInfoSet syncInfoSet = this.getPaneSyncInfoSetToProcess();
        return syncInfoSet.getResources();
    }

    public IResource[] getNotSelectedResources() {
        return this.resourcesRemovedFromPane.toArray(new IResource[0]);
    }

    public Control createChangesPage(Composite composite) {
        this.pagePane = new ParticipantPagePane(UIMonitorUtility.getShell(), true, this.syncPageConfiguration, (ISynchronizeParticipant)this.participant);
        Control control = this.pagePane.createPartControl(composite);
        return control;
    }

    protected SyncInfoSet getPaneSyncInfoSet() {
        SyncInfoSet syncInfoSet = null;
        ISynchronizePage page = this.syncPageConfiguration.getPage();
        if (page instanceof SubscriberParticipantPage) {
            WorkingSetFilteredSyncInfoCollector collector = ((SubscriberParticipantPage)page).getCollector();
            syncInfoSet = collector.getWorkingSetSyncInfoSet();
        }
        return syncInfoSet;
    }

    protected SyncInfoSet getPaneSyncInfoSetToProcess() {
        IDiffElement[] elements;
        SyncInfoSet infos = new SyncInfoSet();
        if (this.syncPageConfiguration == null) {
            return this.participant.getSyncInfoSet();
        }
        ISynchronizeModelElement root = (ISynchronizeModelElement)this.syncPageConfiguration.getProperty("org.eclipse.team.ui.P_MODEL");
        IDiffElement[] iDiffElementArray = elements = Utils.getDiffNodes((Object[])new IDiffElement[]{root});
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffElement element = iDiffElementArray[n2];
            if (element instanceof SyncInfoModelElement) {
                SyncInfo syncInfo = ((SyncInfoModelElement)element).getSyncInfo();
                infos.add(syncInfo);
            }
            ++n2;
        }
        return infos;
    }

    public void dispose() {
        if (this.syncPageConfiguration != null) {
            SyncInfoSet paneSyncInfoSet = this.getPaneSyncInfoSet();
            paneSyncInfoSet.removeSyncSetChangedListener(this.paneSyncInfoSetListener);
        }
        if (this.pagePane != null) {
            this.pagePane.dispose();
        }
        if (this.participant != null) {
            this.participant.dispose();
        }
    }

    public void expandPaneTree() {
        Viewer viewer = this.syncPageConfiguration.getPage().getViewer();
        if (viewer instanceof TreeViewer) {
            try {
                viewer.getControl().setRedraw(false);
                ((TreeViewer)viewer).expandAll();
            }
            finally {
                viewer.getControl().setRedraw(true);
            }
        }
    }

    private class PaneSyncInfoSetListener
    implements ISyncInfoSetChangeListener {
        private PaneSyncInfoSetListener() {
        }

        public void syncInfoChanged(ISyncInfoSetChangeEvent event, IProgressMonitor monitor) {
            IResource[] removed = event.getRemovedResources();
            if (removed.length > 0) {
                PaneParticipantHelper.this.resourcesRemovedFromPane.addAll(Arrays.asList(removed));
            }
        }

        public void syncInfoSetErrors(SyncInfoSet set, ITeamStatus[] errors, IProgressMonitor monitor) {
        }

        public void syncInfoSetReset(SyncInfoSet set, IProgressMonitor monitor) {
        }
    }

    public static class PaneVerifier
    extends AbstractVerifier {
        protected PaneParticipantHelper paneParticipantHelper;

        public PaneVerifier(PaneParticipantHelper paneParticipantHelper) {
            this.paneParticipantHelper = paneParticipantHelper;
        }

        @Override
        protected String getErrorMessage(Control input) {
            IResource[] resources = this.paneParticipantHelper.getSelectedResources();
            if (resources.length == 0) {
                return SVNUIMessages.ParticipantPagePane_Verifier_Error;
            }
            return null;
        }

        @Override
        protected String getWarningMessage(Control input) {
            return null;
        }
    }
}

