/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.repository.RepositoriesView;
import org.eclipse.team.svn.ui.repository.model.RepositoryLocation;

public class RefreshRepositoryLocationsOperation
extends AbstractActionOperation {
    protected IRepositoryLocation[] resources;
    protected boolean deep;

    public RefreshRepositoryLocationsOperation(boolean deep) {
        this(null, deep);
    }

    public RefreshRepositoryLocationsOperation(IRepositoryLocation[] resources, boolean deep) {
        super("Operation_RefreshLocations", SVNUIMessages.class);
        this.resources = resources;
        this.deep = deep;
    }

    public int getOperationWeight() {
        return 0;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        if (this.resources == null) {
            RepositoriesView.refreshRepositories(this.deep);
            return;
        }
        IRepositoryLocation[] iRepositoryLocationArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryLocation current = iRepositoryLocationArray[n2];
            this.protectStep(monitor1 -> RepositoriesView.refresh(current, data -> {
                if (data instanceof RepositoryLocation && this.deep) {
                    ((RepositoryLocation)data).refresh();
                }
            }), monitor, this.resources.length);
            ++n2;
        }
    }
}

