/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.team.svn.core.connector.SVNConnectorAuthenticationException;
import org.eclipse.team.svn.core.connector.SVNConnectorCancelException;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class GetBranchesTagsOperation
extends AbstractActionOperation {
    protected IRepositoryContainer parent;
    protected boolean isBranch;
    protected IRepositoryResource[] children;

    public GetBranchesTagsOperation(IRepositoryContainer parent, boolean isBranch) {
        super("Operation_GetBranchesTags", SVNUIMessages.class);
        this.parent = parent;
        this.isBranch = isBranch;
    }

    public IRepositoryResource[] getChildren() {
        return this.children == null ? new IRepositoryResource[]{} : this.children;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        boolean hasError;
        block3: {
            hasError = false;
            try {
                this.children = this.parent.getChildren();
            }
            catch (SVNConnectorException se) {
                if (se instanceof SVNConnectorAuthenticationException || se instanceof SVNConnectorCancelException) break block3;
                hasError = true;
            }
        }
        if (hasError || this.getChildren().length == 0) {
            UIMonitorUtility.getDisplay().syncExec(() -> {
                MessageDialog dialog = new MessageDialog(UIMonitorUtility.getShell(), SVNUIMessages.ComparePropsNoDiff_Title, null, this.isBranch ? SVNUIMessages.BranchTagSelectionComposite_NoBranches : SVNUIMessages.BranchTagSelectionComposite_NoTags, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.open();
            });
        }
    }
}

