/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSetManager;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.mapping.SVNIncomingChangeSet;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.utility.DateFormatter;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;

public class SVNIncomingChangeSetCollector
extends ChangeSetManager {
    protected ISynchronizePageConfiguration configuration;
    protected Subscriber subscriber;

    public SVNIncomingChangeSetCollector(ISynchronizePageConfiguration configuration, Subscriber subscriber) {
        this.configuration = configuration;
        this.subscriber = subscriber;
    }

    protected void initializeSets() {
    }

    public void add(IDiff[] diffs) {
        if (diffs == null || diffs.length == 0) {
            return;
        }
        String svnAuthor = SVNMessages.SVNInfo_Author;
        String svnDate = SVNMessages.SVNInfo_Date;
        String svnNoAuthor = SVNMessages.SVNInfo_NoAuthor;
        String svnNoDate = SVNMessages.SVNInfo_NoDate;
        HashMap<Long, SVNIncomingChangeSet> sets = new HashMap<Long, SVNIncomingChangeSet>();
        HashSet<SVNIncomingChangeSet> added = new HashSet<SVNIncomingChangeSet>();
        ChangeSet[] changeSetArray = this.getSets();
        int n = changeSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet changeSet = changeSetArray[n2];
            SVNIncomingChangeSet svnSet = (SVNIncomingChangeSet)changeSet;
            sets.put(svnSet.getRevision(), svnSet);
            ++n2;
        }
        try {
            changeSetArray = diffs;
            n = diffs.length;
            n2 = 0;
            while (n2 < n) {
                ChangeSet changeSet = changeSetArray[n2];
                SyncInfo info = this.subscriber.getSyncInfo(ResourceDiffTree.getResourceFor((IDiff)changeSet));
                if (info != null && (info.getKind() & 8) != 0) {
                    ILocalResource resource = ((AbstractSVNSyncInfo)info).getRemoteChangeResource();
                    long revision = resource.getRevision();
                    SVNIncomingChangeSet set = (SVNIncomingChangeSet)sets.get(revision);
                    boolean updateName = false;
                    if (set == null) {
                        set = new SVNIncomingChangeSet();
                        set.setAuthor(resource.getAuthor());
                        set.setDate(new Date(resource.getLastCommitDate()));
                        set.setRevision(Long.valueOf(revision));
                        if (resource instanceof IResourceChange) {
                            set.setComment(((IResourceChange)resource).getComment());
                        }
                        updateName = true;
                        sets.put(revision, set);
                        added.add(set);
                    } else if (set.getDate().getTime() == 0L) {
                        updateName = true;
                        set.setDate(new Date(resource.getLastCommitDate()));
                    } else if (set.getAuthor() == null) {
                        updateName = true;
                        set.setAuthor(resource.getAuthor());
                    }
                    if (updateName) {
                        String name = String.valueOf(revision) + " " + (resource.getLastCommitDate() == 0L ? svnNoDate : BaseMessages.format((String)svnDate, (Object[])new Object[]{DateFormatter.formatDate(set.getDate())})) + " " + (resource.getAuthor() == null ? svnNoAuthor : BaseMessages.format((String)svnAuthor, (Object[])new Object[]{resource.getAuthor()}));
                        if (set.getComment() != null) {
                            String comment = set.getComment();
                            if (FileUtility.isWindows()) {
                                comment = comment.replaceAll("\r\n|\r|\n", " ");
                            }
                            name = name + " " + comment;
                        }
                        set.setName(name);
                    }
                    set.add((IDiff)changeSet);
                }
                ++n2;
            }
            for (SVNIncomingChangeSet sVNIncomingChangeSet : added) {
                this.add((ChangeSet)sVNIncomingChangeSet);
            }
        }
        catch (TeamException teamException) {
            LoggedOperation.reportError((String)((Object)((Object)this)).getClass().getName(), (Throwable)teamException);
        }
    }

    public void handleChange(IDiffChangeEvent event) {
        IDiff[] changed;
        ArrayList<IPath> removals = new ArrayList<IPath>(Arrays.asList(event.getRemovals()));
        ArrayList<IDiff> additions = new ArrayList<IDiff>(Arrays.asList(event.getAdditions()));
        IDiff[] iDiffArray = changed = event.getChanges();
        int n = changed.length;
        int n2 = 0;
        while (n2 < n) {
            IDiff diff = iDiffArray[n2];
            additions.add(diff);
            removals.add(diff.getPath());
            ++n2;
        }
        if (!removals.isEmpty()) {
            this.remove(removals.toArray(new IPath[removals.size()]));
        }
        if (!additions.isEmpty()) {
            this.add(additions.toArray(new IDiff[additions.size()]));
        }
    }

    protected void remove(IPath[] paths) {
        ChangeSet[] sets;
        ChangeSet[] changeSetArray = sets = this.getSets();
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet set2 = changeSetArray[n2];
            DiffChangeSet set = (DiffChangeSet)set2;
            set.remove(paths);
            ++n2;
        }
    }

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    public ChangeSetCapability getChangeSetCapability() {
        ISynchronizeParticipant participant = this.configuration.getParticipant();
        if (participant instanceof IChangeSetProvider) {
            IChangeSetProvider provider = (IChangeSetProvider)participant;
            return provider.getChangeSetCapability();
        }
        return null;
    }
}

