/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.lock;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;

public class LockResource
implements IAdaptable {
    protected final boolean isFile;
    protected final LockStatusEnum lockStatus;
    protected String name;
    protected final String owner;
    protected final Date creationDate;
    protected final String comment;
    protected LockResource parent;
    protected Set<LockResource> children;
    protected String url;
    protected String fullFileSystemPath;

    public LockResource(String name, String owner, boolean isFile, LockStatusEnum lockStatus, Date creationDate, String comment, String fullFileSystemPath, String url) {
        this.name = name;
        this.owner = owner;
        this.isFile = isFile;
        this.lockStatus = lockStatus;
        this.creationDate = creationDate;
        this.comment = comment;
        this.fullFileSystemPath = fullFileSystemPath;
        this.url = url;
        if (!this.isFile) {
            this.children = new HashSet<LockResource>();
        }
    }

    public void addChild(LockResource lockResource) {
        if (!this.isFile && this.children.add(lockResource)) {
            lockResource.parent = this;
        }
    }

    public void addChildren(LockResource[] lockResources) {
        if (!this.isFile) {
            LockResource[] lockResourceArray = lockResources;
            int n = lockResources.length;
            int n2 = 0;
            while (n2 < n) {
                LockResource lockResource = lockResourceArray[n2];
                this.addChild(lockResource);
                ++n2;
            }
        }
    }

    public LockResource[] getChildren() {
        return this.isFile ? new LockResource[]{} : this.children.toArray(new LockResource[0]);
    }

    public void removeChild(LockResource lockResource) {
        if (!this.isFile && this.children.remove(lockResource)) {
            lockResource.parent = null;
        }
    }

    public LockResource getChildByName(String childName) {
        if (this.isFile) {
            return null;
        }
        for (LockResource child : this.children) {
            if (!child.getName().equals(childName)) continue;
            return child;
        }
        return null;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public String getPath() {
        return this.isRoot() ? this.name : this.parent.getPath() + "/" + this.name;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public LockStatusEnum getLockStatus() {
        return this.lockStatus;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public LockResource getParent() {
        return this.parent;
    }

    public String getComment() {
        return this.comment;
    }

    public String getFullFileSystemPath() {
        return this.fullFileSystemPath;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return this.getPath();
    }

    public void accept(ILockResourceVisitor visitor) {
        visitor.visit(this);
    }

    public LockResource[] getAllChildFiles() {
        final ArrayList res = new ArrayList();
        this.accept(new ILockResourceVisitor(){

            @Override
            public void visit(LockResource lockResource) {
                if (lockResource.isFile()) {
                    res.add(lockResource);
                } else {
                    LockResource[] children;
                    LockResource[] lockResourceArray = children = lockResource.getChildren();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LockResource child = lockResourceArray[n2];
                        this.visit(child);
                        ++n2;
                    }
                }
            }
        });
        return res.toArray(new LockResource[0]);
    }

    public void showResourcesTree() {
        this.accept(new ILockResourceVisitor(){
            protected int indent;

            @Override
            public void visit(LockResource lockResource) {
                LockResource[] children;
                String str = this.getStrIndent() + "Name: " + lockResource.getName() + ", path: " + lockResource.getPath();
                if (lockResource.isFile()) {
                    str = str + ", lock status: " + lockResource.getLockStatus().toString();
                }
                System.out.println(str);
                LockResource[] lockResourceArray = children = lockResource.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    LockResource child = lockResourceArray[n2];
                    ++this.indent;
                    this.visit(child);
                    --this.indent;
                    ++n2;
                }
            }

            protected String getStrIndent() {
                StringBuilder res = new StringBuilder();
                int i = 0;
                while (i < this.indent) {
                    res.append("\t");
                    ++i;
                }
                return res.toString();
            }
        });
    }

    public Object getAdapter(Class adapter) {
        if (this.isFile() && this.fullFileSystemPath != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IContainer parent = (IContainer)root.findMember(this.parent.getPath());
            IFile file = parent.getFile((IPath)new Path(this.name));
            if (adapter == IResource.class) {
                return file;
            }
            if (adapter == IRepositoryResource.class && file != null && this.url != null) {
                return SVNRemoteStorage.instance().asRepositoryResource(SVNRemoteStorage.instance().getRepositoryLocation((IResource)file), this.url, true);
            }
        }
        return null;
    }

    public static LockResource[] getLockResources(IResource[] resourcesToProcess, boolean locked) {
        ArrayList<LockResource> res = new ArrayList<LockResource>();
        IResource[] iResourceArray = resourcesToProcess;
        int n = resourcesToProcess.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getParent() != null) {
                ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
                if (locked && local.isLocked() || !locked && !local.isLocked()) {
                    String parentPath = resource.getParent().getFullPath().toString();
                    if (parentPath.startsWith("/")) {
                        parentPath = parentPath.substring(1);
                    }
                    LockResource lr = local.isLocked() ? new LockResource(resource.getName(), null, true, LockStatusEnum.LOCALLY_LOCKED, null, null, FileUtility.getWorkingCopyPath((IResource)resource), null) : LockResource.createNotLockedFile(resource.getName(), FileUtility.getWorkingCopyPath((IResource)resource));
                    LockResource directory = LockResource.createDirectory(parentPath);
                    directory.addChild(lr);
                    res.add(lr);
                }
            }
            ++n2;
        }
        return res.toArray(new LockResource[res.size()]);
    }

    public static LockResource createDirectory(String directoryName) {
        return new LockResource(directoryName, null, false, LockStatusEnum.NONE, null, null, null, null);
    }

    public static LockResource createNotLockedFile(String fileName, String fullFileSystemPath) {
        return new LockResource(fileName, null, true, LockStatusEnum.NONE, null, null, fullFileSystemPath, null);
    }

    public static interface ILockResourceVisitor {
        public void visit(LockResource var1);
    }

    public static enum LockStatusEnum {
        NONE,
        LOCALLY_LOCKED,
        OTHER_LOCKED,
        BROKEN,
        STOLEN;

    }
}

