/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.discovery;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.team.svn.core.discovery.util.WebUtil;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.svnstorage.SVNCachedProxyCredentialsManager;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.discovery.PrepareInstallProfileJob_3_6;
import org.eclipse.team.svn.ui.discovery.wizards.ConnectorDiscoveryWizard;
import org.eclipse.team.svn.ui.panel.callback.PromptCredentialsPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class DiscoveryConnectorsHelper {
    public void run(IProgressMonitor monitor) throws Exception {
        if (CoreExtensionsManager.instance().getAccessibleClients().isEmpty() && Platform.getBundle((String)"org.eclipse.equinox.p2.repository") != null) {
            try {
                PrepareInstallProfileJob_3_6 installJob = new PrepareInstallProfileJob_3_6();
                if (installJob != null) {
                    WebUtil.setAuthenticator((Authenticator)new ProxyAuthenticator());
                    UIMonitorUtility.getDisplay().asyncExec(() -> {
                        ConnectorDiscoveryWizard wizard = new ConnectorDiscoveryWizard(installJob);
                        WizardDialog dialog = new WizardDialog(UIMonitorUtility.getShell(), (IWizard)wizard);
                        dialog.open();
                    });
                }
            }
            catch (Throwable e) {
                throw new UnreportableException("Errors occured while initializing provisioning framework. This make cause discovery install to fail.", e);
            }
        }
    }

    protected static class ProxyAuthenticator
    extends Authenticator {
        protected ProxyAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                SVNCachedProxyCredentialsManager proxyCredentialsManager = SVNRemoteStorage.instance().getProxyCredentialsManager();
                if (proxyCredentialsManager.getUsername() == null || proxyCredentialsManager.getUsername() == "") {
                    boolean[] result = new boolean[1];
                    UIMonitorUtility.getDisplay().syncExec(() -> {
                        PromptCredentialsPanel panel = new PromptCredentialsPanel(this.getRequestingPrompt(), 3);
                        DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                        if (dialog.open() == 0) {
                            blArray[0] = true;
                        }
                    });
                    if (result[0]) {
                        String pswd = proxyCredentialsManager.getPassword();
                        return new PasswordAuthentication(proxyCredentialsManager.getUsername(), pswd == null ? "".toCharArray() : pswd.toCharArray());
                    }
                } else {
                    String pswd = proxyCredentialsManager.getPassword();
                    return new PasswordAuthentication(proxyCredentialsManager.getUsername(), pswd == null ? "".toCharArray() : pswd.toCharArray());
                }
            }
            return null;
        }
    }
}

