/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.dialog;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;

public class OperationErrorDialog
extends MessageDialog {
    public static final int ERR_NONE = -1;
    public static final int ERR_DIFFREPOSITORIES = 0;
    public static final int ERR_DIFFPROJECTS = 1;
    protected static final String[] errorMessages = new String[]{"OperationErrorDialog_Message_DifferentRepositories", "OperationErrorDialog_Message_DifferentProjects"};

    public OperationErrorDialog(Shell parentShell, String title, int errorCode) {
        this(parentShell, title, SVNUIMessages.getString(errorMessages[errorCode]));
    }

    public OperationErrorDialog(Shell parentShell, String title, String errorMessage) {
        super(parentShell, title, null, errorMessage, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
    }

    public static boolean isAcceptableAtOnce(IResource[] resources, String name, Shell shell) {
        IRepositoryResource[] remoteResources = new IRepositoryResource[resources.length];
        int i = 0;
        while (i < resources.length) {
            remoteResources[i] = SVNRemoteStorage.instance().asRepositoryResource(resources[i]);
            ++i;
        }
        return OperationErrorDialog.isAcceptableAtOnce(remoteResources, name, shell);
    }

    public static boolean isAcceptableAtOnce(IRepositoryResource[] resources, String name, Shell shell) {
        IRepositoryLocation first = resources[0].getRepositoryLocation();
        String url = SVNUtility.getTrunkLocation((IRepositoryResource)resources[0]).getUrl();
        int i = 1;
        while (i < resources.length) {
            if (resources[i].getRepositoryLocation() != first) {
                new OperationErrorDialog(shell, name, 0).open();
                return false;
            }
            if (!url.equals(SVNUtility.getTrunkLocation((IRepositoryResource)resources[i]).getUrl())) {
                new OperationErrorDialog(shell, name, 1).open();
                return false;
            }
            ++i;
        }
        return true;
    }
}

