/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.panel.IDialogManager;
import org.eclipse.team.svn.ui.panel.IDialogPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.PlatformUI;

public class DefaultDialog
extends MessageDialog
implements IDialogManager {
    public static final int DIALOG_FAILED = -1;
    public static final int BUTTON_WIDTH = 76;
    protected Listener keyListener;
    protected IDialogPanel panel;
    protected Control infoPanel;
    protected Font mainLabelFont;
    protected Label message;
    protected Label icon;
    protected Image infoImage;
    protected Image levelOkImage;
    protected Image levelWarningImage;
    protected Image levelErrorImage;
    protected Composite mainComposite;

    public DefaultDialog(Shell parentShell, IDialogPanel panel) {
        super(parentShell, panel.getDialogTitle(), null, null, 0, panel.getButtonNames(), 0);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.panel = panel;
        this.levelOkImage = this.findImage("icons/common/level_ok.gif");
        this.levelWarningImage = this.findImage("icons/common/level_warning.gif");
        this.levelErrorImage = this.findImage("icons/common/level_error.gif");
    }

    public static int convertHeightInCharsToPixels(Control control, int chars) {
        GC gc = new GC((Drawable)control);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return fontMetrics.getHeight() * chars;
    }

    public static int computeButtonWidth(Button button) {
        int width = button.computeSize((int)-1, (int)-1).x + 6;
        return Math.max(width, 76);
    }

    @Override
    public void setButtonEnabled(int idx, boolean enabled) {
        this.getButton(idx).setEnabled(enabled);
    }

    @Override
    public boolean isButtonEnabled(int idx) {
        return this.getButton(idx).getEnabled();
    }

    @Override
    public void setMessage(int level, String message) {
        Image img = this.levelOkImage;
        switch (level) {
            case 2: {
                img = this.levelErrorImage;
                break;
            }
            case 1: {
                img = this.levelWarningImage;
            }
        }
        if (message == null) {
            message = this.panel.getDefaultMessage();
        }
        this.message.setText(message == null ? "" : message);
        this.icon.setImage(img);
    }

    public int open() {
        try {
            this.setReturnCode(-1);
            int n = super.open();
            return n;
        }
        finally {
            this.dispose();
        }
    }

    @Override
    public void forceClose(int buttonID) {
        if (this.isButtonEnabled(buttonID)) {
            this.buttonPressed(buttonID);
        }
    }

    protected void dispose() {
        if (this.panel != null) {
            this.panel.dispose();
        }
        if (this.mainLabelFont != null) {
            this.mainLabelFont.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.levelOkImage != null) {
            this.levelOkImage.dispose();
        }
        if (this.levelWarningImage != null) {
            this.levelWarningImage.dispose();
        }
        if (this.levelErrorImage != null) {
            this.levelErrorImage.dispose();
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId != 1) {
            this.panel.buttonPressed(buttonId);
        }
        super.buttonPressed(buttonId);
    }

    protected Control createContents(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        this.mainComposite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.mainComposite.setLayout((Layout)layout);
        data = new GridData(1808);
        this.mainComposite.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)this.mainComposite);
        this.initializeDialogUnits((Control)this.mainComposite);
        this.infoPanel = this.createInfoPanel(this.mainComposite);
        this.dialogArea = this.createMainPanel(this.mainComposite);
        this.createBottomPanel(this.mainComposite);
        Point defaultSize = this.dialogArea.getShell().computeSize(-1, -1, true);
        data = (GridData)this.dialogArea.getLayoutData();
        int defaultHeightHint = data.heightHint;
        data.heightHint = this.panel.getPrefferedSize().y;
        this.dialogArea.setLayoutData((Object)data);
        Point prefferedSize = this.dialogArea.getShell().computeSize(-1, -1, true);
        if (prefferedSize.y < defaultSize.y) {
            data.heightHint = defaultHeightHint;
            this.dialogArea.setLayoutData((Object)data);
        }
        this.panel.initPanel(this);
        this.panel.addListeners();
        this.panel.postInit();
        String hId = this.panel.getHelpId();
        if (hId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.mainComposite, hId);
        }
        return this.mainComposite;
    }

    public void create() {
        super.create();
        this.keyListener = event -> {
            if (event.stateMask == 262144 && event.keyCode == 13) {
                this.forceClose(0);
                event.doit = false;
            }
        };
        this.getShell().getDisplay().addFilter(1, this.keyListener);
    }

    public boolean close() {
        if (this.keyListener != null) {
            this.getShell().getDisplay().removeFilter(1, this.keyListener);
        }
        if (this.getReturnCode() == 1) {
            this.panel.buttonPressed(1);
        }
        return this.panel.canClose() && super.close();
    }

    protected Control createInfoPanel(Composite parent) {
        Color bgColor = new Color(null, 255, 255, 255);
        GridLayout layout = null;
        GridData data = null;
        Composite infoPanel = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        layout.numColumns = 2;
        infoPanel.setLayout((Layout)layout);
        data = new GridData(768);
        Point pt = this.panel.getPrefferedSize();
        data.widthHint = pt.x;
        infoPanel.setLayoutData((Object)data);
        infoPanel.setBackground(bgColor);
        Composite leftSide = new Composite(infoPanel, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 1;
        leftSide.setLayout((Layout)layout);
        data = new GridData(1808);
        leftSide.setLayoutData((Object)data);
        leftSide.setBackground(bgColor);
        Label iconLabel = new Label(infoPanel, 0);
        this.infoImage = this.findImage(this.panel.getImagePath());
        iconLabel.setImage(this.infoImage);
        Font defaultFont = JFaceResources.getBannerFont();
        FontData[] fData = defaultFont.getFontData();
        this.mainLabelFont = new Font((Device)UIMonitorUtility.getDisplay(), fData);
        Label description = new Label(leftSide, 64);
        data = new GridData(768);
        data.horizontalSpan = 2;
        description.setLayoutData((Object)data);
        String text = this.panel.getDialogDescription();
        description.setText(text != null ? text : "");
        description.setFont(this.mainLabelFont);
        description.setBackground(bgColor);
        this.icon = new Label(leftSide, 0);
        data = new GridData();
        data.verticalAlignment = 1;
        this.icon.setLayoutData((Object)data);
        this.icon.setBackground(bgColor);
        this.message = new Label(leftSide, 64);
        data = new GridData(1808);
        data.horizontalIndent = 3;
        this.message.setLayoutData((Object)data);
        this.message.setBackground(bgColor);
        this.setMessage(0, null);
        return infoPanel;
    }

    protected Control createMainPanel(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite fullSizePanel = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        fullSizePanel.setLayout((Layout)layout);
        data = new GridData(1808);
        fullSizePanel.setLayoutData((Object)data);
        Label separator = new Label(fullSizePanel, 258);
        separator.setLayoutData((Object)new GridData(768));
        Composite customPanel = new Composite(fullSizePanel, 0);
        layout = new GridLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        customPanel.setLayout((Layout)layout);
        data = new GridData(1808);
        Point pt = this.panel.getPrefferedSize();
        data.widthHint = pt.x;
        customPanel.setLayoutData((Object)data);
        separator = new Label(fullSizePanel, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.panel.createControls(customPanel);
        return customPanel;
    }

    protected Control createBottomPanel(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        data = new GridData(768);
        composite.setLayoutData((Object)data);
        this.createHelpImageButton(composite);
        this.buttonBar = this.createButtonPanel(composite);
        ((GridData)this.buttonBar.getLayoutData()).horizontalIndent = 7;
        return composite;
    }

    protected ToolBar createHelpImageButton(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 0x880000);
        ++((GridLayout)parent.getLayout()).numColumns;
        toolBar.setLayoutData((Object)new GridData(64));
        Cursor cursor = new Cursor((Device)parent.getDisplay(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(e -> cursor.dispose());
        ToolItem item = new ToolItem(toolBar, 0);
        item.setImage(JFaceResources.getImage((String)"dialog_help_image"));
        item.setToolTipText(JFaceResources.getString((String)"helpToolTip"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDialog.this.mainComposite.notifyListeners(28, new Event());
            }
        });
        return toolBar;
    }

    protected Control createButtonPanel(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite buttonPanel = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonPanel.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalAlignment = 131072;
        buttonPanel.setLayoutData((Object)data);
        return this.createButtonBar(buttonPanel);
    }

    protected Image findImage(String imagePath) {
        SVNTeamUIPlugin plugin = SVNTeamUIPlugin.instance();
        ImageDescriptor descriptor = plugin.getImageDescriptor(imagePath == null ? "icons/wizards/newconnect.gif" : imagePath);
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return descriptor.createImage();
    }
}

