/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.crashrecovery;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.extension.crashrecovery.ErrorDescription;
import org.eclipse.team.svn.core.extension.crashrecovery.IResolutionHelper;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.UpgradeWorkingCopyOperation;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class UpgradeWorkingCopyHelper
implements IResolutionHelper {
    public boolean acquireResolution(ErrorDescription description) {
        if (description.code == ErrorDescription.WORKING_COPY_REQUIRES_UPGRADE) {
            IProject project = (IProject)description.context;
            boolean[] solved = new boolean[1];
            UIMonitorUtility.parallelSyncExec(() -> {
                String title = BaseMessages.format((String)SVNUIMessages.UpgradeWorkingCopyDialog_Title, (Object[])new String[]{project.getName()});
                MessageDialog dlg = new MessageDialog(UIMonitorUtility.getShell(), title, null, SVNUIMessages.UpgradeWorkingCopyDialog_Message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                if (dlg.open() == 0) {
                    UIMonitorUtility.doTaskNowDefault(UIMonitorUtility.getShell(), (IActionOperation)new UpgradeWorkingCopyOperation(new IResource[]{project}), false);
                    blArray[0] = true;
                }
            });
            return solved[0];
        }
        return false;
    }
}

