/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.RepositoryResourceBaseSelectionComposite;
import org.eclipse.team.svn.ui.composite.RevisionComposite;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.common.RepositoryTreePanel;
import org.eclipse.team.svn.ui.verifier.AbsolutePathVerifier;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.IValidationManager;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.URLVerifier;

public class RepositoryResourceSelectionComposite
extends RepositoryResourceBaseSelectionComposite {
    public static final int MODE_DEFAULT = 0;
    public static final int MODE_TWO = 1;
    public static final int MODE_CHECK = 2;
    public static final int TEXT_NONE = 0;
    public static final int TEXT_BASE = 1;
    public static final int TEXT_LAST = 2;
    protected RevisionComposite revisionComposite;
    protected RevisionComposite secondRevisionComposite;
    protected boolean stopOnCopy;
    protected boolean toFilterCurrent;
    protected int mode;
    protected int defaultTextType;

    public RepositoryResourceSelectionComposite(Composite parent, int style, IValidationManager validationManager, String historyKey, IRepositoryResource baseResource, boolean stopOnCopy, String selectionTitle, String selectionDescription, int mode, int defaultTextType) {
        this(parent, style, validationManager, historyKey, "RepositoryResourceSelectionComposite_URL", baseResource, stopOnCopy, selectionTitle, selectionDescription, mode, defaultTextType);
    }

    public RepositoryResourceSelectionComposite(Composite parent, int style, IValidationManager validationManager, String historyKey, String comboId, IRepositoryResource baseResource, boolean stopOnCopy, String selectionTitle, String selectionDescription, int mode, int defaultTextType) {
        super(parent, style, validationManager, historyKey, comboId, baseResource, selectionTitle, selectionDescription);
        this.stopOnCopy = stopOnCopy;
        this.toFilterCurrent = false;
        this.mode = mode;
        this.defaultTextType = defaultTextType;
        this.createControls(defaultTextType);
    }

    @Override
    protected void setBaseResourceImpl() {
        if (this.revisionComposite != null) {
            this.revisionComposite.setBaseResource(this.baseResource);
        }
        if (this.secondRevisionComposite != null) {
            this.secondRevisionComposite.setBaseResource(this.baseResource);
        }
        if (this.defaultTextType == 1 && this.baseResource != null) {
            super.setBaseResourceImpl();
        }
    }

    public void setFilterCurrent(boolean toFilter) {
        this.toFilterCurrent = toFilter;
        this.revisionComposite.setFilterCurrent(this.toFilterCurrent);
    }

    public boolean isReverseRevisions() {
        return this.revisionComposite.isReverseRevisions();
    }

    public boolean isReverseSecondResourceRevisions() {
        return this.secondRevisionComposite != null ? this.secondRevisionComposite.isReverseRevisions() : false;
    }

    @Override
    public IRepositoryResource getSelectedResource() {
        IRepositoryResource resource = super.getSelectedResource();
        resource.setSelectedRevision(this.revisionComposite.getSelectedRevision());
        return resource;
    }

    public IRepositoryResource getSecondSelectedResource() {
        if (this.secondRevisionComposite == null) {
            return null;
        }
        IRepositoryResource resource = super.getSelectedResource();
        resource.setSelectedRevision(this.secondRevisionComposite.getSelectedRevision());
        return resource;
    }

    public SVNRevisionRange[] getSelectedRevisions() {
        if (this.mode == 2) {
            return this.revisionComposite.getSelectedRevisions();
        }
        SVNRevision first = this.getSelectedResource().getSelectedRevision();
        SVNRevision second = this.getSecondSelectedRevision();
        return new SVNRevisionRange[]{new SVNRevisionRange(first, second == null ? first : second)};
    }

    public SVNRevision getStartRevision() {
        return this.revisionComposite.getSelectedRevision();
    }

    public SVNRevision getSecondSelectedRevision() {
        if (this.secondRevisionComposite == null) {
            return null;
        }
        return this.secondRevisionComposite.getSelectedRevision();
    }

    public void setCurrentRevision(long currentRevision) {
        this.revisionComposite.setCurrentRevision(currentRevision);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.revisionComposite.setEnabled(enabled);
        if (this.secondRevisionComposite != null) {
            this.secondRevisionComposite.setEnabled(enabled);
        }
    }

    private void createControls(int defaultTextType) {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        Label urlLabel = new Label((Composite)this, 0);
        urlLabel.setLayoutData((Object)new GridData());
        urlLabel.setText(SVNUIMessages.getString(this.comboId));
        Composite select = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        select.setLayout((Layout)layout);
        data = new GridData(768);
        select.setLayoutData((Object)data);
        this.urlText = new Combo(select, 0);
        data = new GridData(768);
        data.widthHint = 200;
        this.urlText.setLayoutData((Object)data);
        this.urlText.setVisibleItemCount(this.urlHistory.getDepth());
        this.urlText.setItems(this.urlHistory.getHistory());
        if (defaultTextType == 1 && this.baseResource != null) {
            this.urlText.setText(this.baseResource.getUrl());
        } else if (defaultTextType == 2 && this.urlText.getItemCount() > 0) {
            this.urlText.select(0);
        }
        this.url = this.urlText.getText();
        Listener urlTextListener = e -> {
            this.url = ((Combo)e.widget).getText();
            if (this.isSelectionAvailable()) {
                this.revisionComposite.setSelectedResource(this.getSelectedResource());
                boolean toFilter = this.toFilterCurrent && this.baseResource != null && (this.getSelectedResource().getUrl().equals(this.baseResource.getUrl()) || this.getSelectedResource().getUrl().equals(this.baseResource.getUrl() + "/"));
                this.revisionComposite.setFilterCurrent(toFilter);
                if (this.secondRevisionComposite != null) {
                    this.secondRevisionComposite.setSelectedResource(this.getSecondSelectedResource());
                    this.secondRevisionComposite.setFilterCurrent(toFilter);
                }
            }
        };
        this.urlText.addListener(24, urlTextListener);
        this.urlText.addListener(13, urlTextListener);
        this.verifier = new CompositeVerifier(){

            @Override
            protected void fireError(String errorReason) {
                RepositoryResourceSelectionComposite.this.revisionComposite.setEnabled(false);
                if (RepositoryResourceSelectionComposite.this.secondRevisionComposite != null) {
                    RepositoryResourceSelectionComposite.this.secondRevisionComposite.setEnabled(false);
                }
                super.fireError(errorReason);
            }

            @Override
            protected void fireOk() {
                RepositoryResourceSelectionComposite.this.revisionComposite.setEnabled(true);
                if (RepositoryResourceSelectionComposite.this.secondRevisionComposite != null) {
                    RepositoryResourceSelectionComposite.this.secondRevisionComposite.setEnabled(true);
                }
                super.fireOk();
            }
        };
        this.verifier.add(new NonEmptyFieldVerifier(SVNUIMessages.getString(this.comboId + "_Verifier")));
        this.verifier.add(new URLVerifier(SVNUIMessages.getString(this.comboId + "_Verifier")){

            @Override
            protected String getErrorMessage(Control input) {
                String url;
                String error = super.getErrorMessage(input);
                if (RepositoryResourceSelectionComposite.this.baseResource != null && error == null && RepositoryResourceSelectionComposite.this.getDestination(SVNUtility.asEntryReference((String)(url = this.getText(input))), true) == null) {
                    error = BaseMessages.format((String)SVNUIMessages.RepositoryResourceSelectionComposite_URL_Verifier_Error, (Object[])new String[]{url, RepositoryResourceSelectionComposite.this.baseResource.getRepositoryLocation().getUrl()});
                }
                return error;
            }
        });
        this.verifier.add(new AbsolutePathVerifier(this.comboId));
        this.validationManager.attachTo((Control)this.urlText, this.verifier);
        this.browse = new Button(select, 8);
        this.browse.setText(SVNUIMessages.Button_Browse);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.browse);
        this.browse.setLayoutData((Object)data);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IRepositoryResource[] iRepositoryResourceArray;
                String string = RepositoryResourceSelectionComposite.this.selectionTitle;
                String string2 = RepositoryResourceSelectionComposite.this.selectionDescription;
                if (RepositoryResourceSelectionComposite.this.baseResource == null) {
                    iRepositoryResourceArray = new IRepositoryResource[]{};
                } else {
                    IRepositoryResource[] iRepositoryResourceArray2 = new IRepositoryResource[1];
                    iRepositoryResourceArray = iRepositoryResourceArray2;
                    iRepositoryResourceArray2[0] = RepositoryResourceSelectionComposite.this.getSelectedResource();
                }
                RepositoryTreePanel panel = new RepositoryTreePanel(SVNUIMessages.RepositoryResourceSelectionComposite_Select_Title, string, string2, iRepositoryResourceArray, true, true);
                panel.setAllowFiles(!RepositoryResourceSelectionComposite.this.foldersOnly);
                DefaultDialog browser = new DefaultDialog(RepositoryResourceSelectionComposite.this.getShell(), panel);
                if (browser.open() == 0) {
                    IRepositoryResource selectedResource = panel.getSelectedResource();
                    boolean samePeg = RepositoryResourceSelectionComposite.this.baseResource != null && selectedResource.getPegRevision().equals((Object)RepositoryResourceSelectionComposite.this.baseResource.getPegRevision());
                    RepositoryResourceSelectionComposite.this.urlText.setText(samePeg ? selectedResource.getUrl() : SVNUtility.getEntryReference((IRepositoryResource)selectedResource).toString());
                    RepositoryResourceSelectionComposite.this.revisionComposite.setSelectedResource(selectedResource);
                    if (RepositoryResourceSelectionComposite.this.secondRevisionComposite != null) {
                        RepositoryResourceSelectionComposite.this.secondRevisionComposite.setSelectedResource(selectedResource);
                    }
                    RepositoryResourceSelectionComposite.this.validationManager.validateContent();
                }
            }
        });
        Composite revisions = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        revisions.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        revisions.setLayoutData((Object)data);
        String revTitle = SVNUIMessages.RevisionComposite_Revision;
        if (this.mode == 1) {
            revTitle = SVNUIMessages.RepositoryResourceSelectionComposite_StartRevision;
        } else if (this.mode == 2) {
            revTitle = SVNUIMessages.RevisionComposite_Revisions;
        }
        String revHeadName = this.mode == 2 ? SVNUIMessages.RevisionComposite_All : SVNUIMessages.RevisionComposite_HeadRevision;
        this.revisionComposite = new RevisionComposite(revisions, this.validationManager, this.stopOnCopy, new String[]{revTitle, revHeadName}, SVNRevision.HEAD, this.mode == 2){

            @Override
            public void additionalValidation() {
                RepositoryResourceSelectionComposite.this.validateRevisions();
            }
        };
        data = new GridData(768);
        data.horizontalSpan = this.mode == 1 ? 1 : 2;
        this.revisionComposite.setLayoutData(data);
        this.revisionComposite.setBaseResource(this.baseResource);
        if (this.baseResource != null) {
            this.revisionComposite.setSelectedResource(this.getSelectedResource());
        }
        if (this.mode == 1) {
            this.secondRevisionComposite = new RevisionComposite(revisions, this.validationManager, this.stopOnCopy, new String[]{SVNUIMessages.RepositoryResourceSelectionComposite_StopRevision, SVNUIMessages.RepositoryResourceSelectionComposite_HeadRevision}, SVNRevision.HEAD, false){

                @Override
                public void additionalValidation() {
                    RepositoryResourceSelectionComposite.this.validateRevisions();
                }
            };
            data = new GridData(768);
            this.secondRevisionComposite.setLayoutData(data);
            this.secondRevisionComposite.setBaseResource(this.baseResource);
            this.secondRevisionComposite.setSelectedResource(this.getSelectedResource());
        }
    }

    protected void validateRevisions() {
        if ((this.mode & 1) != 0) {
            this.validationManager.validateContent();
        }
    }
}

