/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.utility.ArrayStructuredContentProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ProjectListComposite
extends Composite {
    protected IProject[] resources;
    protected TableViewer tableViewer;
    protected Composite parent;
    protected boolean remoteMode;
    protected Map<ImageDescriptor, Image> images;

    public ProjectListComposite(Composite parent, int style, IProject[] resources, boolean remoteMode) {
        super(parent, style);
        this.resources = resources;
        this.remoteMode = remoteMode;
        this.images = new HashMap<ImageDescriptor, Image>();
    }

    public void dispose() {
        for (Image img : this.images.values()) {
            img.dispose();
        }
        super.dispose();
    }

    public void initialize() {
        GridLayout gLayout = new GridLayout();
        gLayout.marginWidth = 0;
        gLayout.marginHeight = 0;
        GridData data = new GridData(1808);
        data.heightHint = 150;
        this.setLayout((Layout)gLayout);
        this.setLayoutData(data);
        Table table = new Table((Composite)this, 68356);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(table);
        data = new GridData(1808);
        this.tableViewer.getTable().setLayoutData((Object)data);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(false);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(20, false));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNUIMessages.ProjectListComposite_ProjectName);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(this.remoteMode ? SVNUIMessages.ProjectListComposite_RepositoryLabel : SVNUIMessages.ProjectListComposite_RepositoryURL);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, true));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    IWorkbenchAdapter adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);
                    if (adapter == null) {
                        return null;
                    }
                    ImageDescriptor descriptor = adapter.getImageDescriptor(element);
                    if (descriptor == null) {
                        return null;
                    }
                    Image image = ProjectListComposite.this.images.get(descriptor);
                    if (image == null) {
                        image = descriptor.createImage();
                        ProjectListComposite.this.images.put(descriptor, image);
                    }
                    return image;
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                IResource resource = (IResource)element;
                if (columnIndex == 1) {
                    return resource.getName();
                }
                if (columnIndex == 2) {
                    SVNRemoteStorage storage = SVNRemoteStorage.instance();
                    if (ProjectListComposite.this.remoteMode) {
                        return storage.getRepositoryLocation(resource).getLabel();
                    }
                    return storage.asRepositoryResource(resource).getUrl();
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new ArrayStructuredContentProvider());
        this.tableViewer.setInput((Object)this.resources);
    }
}

