/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.verifier.AbstractVerifierProxy;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.IValidationManager;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.ResourcePathVerifier;

public class DiffFormatComposite
extends Composite {
    protected Button generateUDiffCheckbox;
    protected Text uDiffPath;
    protected Button browseButton;
    protected String diffFile;
    protected IValidationManager validationManager;

    public DiffFormatComposite(Composite parent, IValidationManager validationManager) {
        super(parent, 0);
        this.validationManager = validationManager;
        this.createControls();
    }

    public String getDiffFile() {
        return this.diffFile;
    }

    protected void createControls() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        GridData data = new GridData(768);
        this.setLayoutData(data);
        this.generateUDiffCheckbox = new Button((Composite)this, 32);
        this.generateUDiffCheckbox.setText(SVNUIMessages.DiffFormatComposite_GenerateDiffFile_Message);
        data = new GridData();
        this.generateUDiffCheckbox.setLayoutData((Object)data);
        this.uDiffPath = new Text((Composite)this, 2052);
        data = new GridData(768);
        this.uDiffPath.setLayoutData((Object)data);
        this.browseButton = new Button((Composite)this, 8);
        this.browseButton.setText(SVNUIMessages.Button_Browse);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.browseButton);
        this.browseButton.setLayoutData((Object)data);
        String name = SVNUIMessages.DiffFormatComposite_DiffFile_Name;
        CompositeVerifier cVerifier = new CompositeVerifier();
        cVerifier.add(new NonEmptyFieldVerifier(name));
        cVerifier.add(new ResourcePathVerifier(name));
        this.validationManager.attachTo((Control)this.uDiffPath, new AbstractVerifierProxy(cVerifier){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return DiffFormatComposite.this.generateUDiffCheckbox.getSelection();
            }
        });
        this.generateUDiffCheckbox.addListener(13, e -> {
            this.validationManager.validateContent();
            this.setEnablement();
        });
        this.browseButton.addListener(13, e -> {
            FileDialog dlg = new FileDialog(this.getShell(), 40960);
            dlg.setFilterExtensions(new String[]{"*.diff", "*.*"});
            dlg.setText(SVNUIMessages.DiffFormatComposite_SaveDiffFileAs);
            String file = dlg.open();
            if (file != null) {
                this.uDiffPath.setText(file);
            }
        });
        this.uDiffPath.addModifyListener(e -> {
            String string = this.diffFile = ((Text)e.widget).getText();
        });
        this.generateUDiffCheckbox.setSelection(false);
        this.setEnablement();
    }

    protected void setEnablement() {
        boolean enabled = this.generateUDiffCheckbox.getSelection();
        this.uDiffPath.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }
}

