/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.annotate;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.internal.text.revisions.RevisionSelectionProvider;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNAnnotationData;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.GetResourceAnnotationOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.annotate.BuiltInAnnotateRevision;
import org.eclipse.team.svn.ui.annotate.CommitterColors;
import org.eclipse.team.svn.ui.annotate.SVNTeamQuickDiffProvider;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.history.SVNHistoryPage;
import org.eclipse.team.svn.ui.operation.OpenRemoteFileOperation;
import org.eclipse.team.svn.ui.panel.common.ShowAnnotationPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.team.ui.history.RevisionAnnotationController;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class BuiltInAnnotate {
    protected AbstractDecoratedTextEditor textEditor;
    protected SVNHistoryPage historyPage;

    public void open(IWorkbenchPage page, IFile resource, Shell parentShell) {
        IActionOperation op = this.getAnnotateOperation(page, resource, parentShell);
        if (op != null) {
            UIMonitorUtility.doTaskScheduledDefault(page.getActivePart(), op);
        }
    }

    public void open(IWorkbenchPage page, IRepositoryResource remote, IFile resource, SVNRevisionRange revisions) {
        IActionOperation op = this.getAnnotateOperation(page, remote, resource, revisions);
        if (op != null) {
            UIMonitorUtility.doTaskScheduledDefault(page.getActivePart(), op);
        }
    }

    public IActionOperation getAnnotateOperation(IWorkbenchPage page, IFile resource, Shell parentShell) {
        if (page == null) {
            return null;
        }
        ILocalResource local = SVNRemoteStorage.instance().asLocalResourceAccessible((IResource)resource);
        SVNRevision revision = local.getRevision() == -1L ? SVNRevision.HEAD : SVNRevision.fromNumber((long)local.getRevision());
        SVNRevision baseRevision = local.getBaseRevision() == -1L ? SVNRevision.HEAD : SVNRevision.fromNumber((long)local.getBaseRevision());
        IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource((IResource)resource);
        remote.setPegRevision(baseRevision);
        remote.setSelectedRevision(revision);
        if (parentShell != null) {
            ShowAnnotationPanel panel = new ShowAnnotationPanel(remote);
            DefaultDialog dialog = new DefaultDialog(parentShell, panel);
            if (dialog.open() == 0) {
                return this.getAnnotateOperation(page, remote, resource, panel.getRevisions());
            }
        } else {
            return this.getAnnotateOperation(page, remote, resource, new SVNRevisionRange((SVNRevision)SVNRevision.fromNumber((long)1L), revision));
        }
        return null;
    }

    public IActionOperation getAnnotateOperation(IWorkbenchPage page, IRepositoryResource remote, IFile resource, SVNRevisionRange revisions) {
        GetResourceAnnotationOperation annotateOp = new GetResourceAnnotationOperation(remote, revisions);
        annotateOp.setIncludeMerged(SVNTeamPreferences.getMergeBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "includeMerged"));
        annotateOp.setRetryIfMergeInfoNotSupported(true);
        IActionOperation showOp = this.prepareBuiltInAnnotate(annotateOp, page, remote, resource);
        CompositeOperation op = new CompositeOperation(showOp.getId(), showOp.getMessagesClass());
        op.add((IActionOperation)annotateOp);
        op.add(showOp, new IActionOperation[]{annotateOp});
        return op;
    }

    protected IActionOperation prepareBuiltInAnnotate(final GetResourceAnnotationOperation annotateOp, final IWorkbenchPage page, final IRepositoryResource remote, final IFile resource) {
        CompositeOperation op = new CompositeOperation("Operation_BuiltInShowAnnotation", SVNUIMessages.class);
        final RevisionInformation info = new RevisionInformation();
        AbstractActionOperation prepareRevisions = new AbstractActionOperation("Operation_PrepareRevisions", SVNUIMessages.class){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                HashMap<String, BuiltInAnnotateRevision> revisions = new HashMap<String, BuiltInAnnotateRevision>();
                SVNAnnotationData[] data = annotateOp.getAnnotatedLines();
                if (data == null || data.length == 0) {
                    return;
                }
                String noAuthor = SVNMessages.SVNInfo_NoAuthor;
                int i = 0;
                while (i < data.length) {
                    if (data[i].revision != -1L) {
                        String revisionId = String.valueOf(data[i].revision);
                        BuiltInAnnotateRevision revision = (BuiltInAnnotateRevision)((Object)revisions.get(revisionId));
                        if (revision == null) {
                            revision = new BuiltInAnnotateRevision(revisionId, data[i].author, CommitterColors.getDefault().getCommitterRGB(data[i].author == null ? noAuthor : data[i].author));
                            revisions.put(revisionId, revision);
                            info.addRevision((Revision)revision);
                        }
                        revision.addLine(i + 1);
                        if (data[i].mergedRevision != -1L && data[i].mergedRevision != data[i].revision) {
                            revision.addMergeInfo(i + 1, data[i].mergedRevision, data[i].mergedDate, data[i].mergedAuthor == null ? noAuthor : data[i].mergedAuthor, data[i].mergedPath);
                        }
                    }
                    ++i;
                }
                if (revisions.size() == 0) {
                    return;
                }
                long from = -1L;
                long to = -1L;
                for (BuiltInAnnotateRevision revision : revisions.values()) {
                    revision.addLine(-1);
                    long revisionNum = revision.getRevision();
                    if (from > revisionNum || from == -1L) {
                        from = revisionNum;
                    }
                    if (to >= revisionNum) continue;
                    to = revisionNum;
                }
                IRepositoryResource resource = annotateOp.getRepositoryResource();
                ISVNConnector proxy = resource.getRepositoryLocation().acquireSVNProxy();
                try {
                    SVNLogEntry[] msgs;
                    SVNLogEntry[] sVNLogEntryArray = msgs = SVNUtility.logEntries((ISVNConnector)proxy, (SVNEntryReference)SVNUtility.getEntryReference((IRepositoryResource)resource), (SVNRevision)SVNRevision.fromNumber((long)to), (SVNRevision)SVNRevision.fromNumber((long)from), (long)0L, (String[])ISVNConnector.DEFAULT_LOG_ENTRY_PROPS, (long)0L, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor, null));
                    int n = msgs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SVNLogEntry msg = sVNLogEntryArray[n2];
                        BuiltInAnnotateRevision revision = (BuiltInAnnotateRevision)((Object)revisions.get(String.valueOf(msg.revision)));
                        if (revision != null) {
                            revision.setLogMessage(msg);
                        }
                        ++n2;
                    }
                }
                finally {
                    resource.getRepositoryLocation().releaseSVNProxy(proxy);
                }
            }
        };
        op.add((IActionOperation)prepareRevisions, new IActionOperation[]{annotateOp});
        AbstractActionOperation attachMessages = new AbstractActionOperation("Operation_BuiltInShowView", SVNUIMessages.class){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                if (page.getActivePart() == null || page.getActivePart().getSite() == null) {
                    return;
                }
                page.getActivePart().getSite().getShell().getDisplay().syncExec(() -> {
                    try {
                        BuiltInAnnotate.this.initializeEditor(page, remote, resource, info);
                    }
                    catch (PartInitException ex) {
                        throw new RuntimeException(ex);
                    }
                });
            }
        };
        op.add((IActionOperation)attachMessages, new IActionOperation[]{annotateOp, prepareRevisions});
        return op;
    }

    protected void initializeEditor(final IWorkbenchPage page, IRepositoryResource remote, IFile resource, RevisionInformation info) throws PartInitException {
        IEditorPart editor;
        IEditorPart iEditorPart = editor = resource != null ? this.openEditor(page, resource) : this.openEditor(page, remote);
        if (editor instanceof AbstractDecoratedTextEditor) {
            this.textEditor = (AbstractDecoratedTextEditor)editor;
            final ISelectionProvider provider = (ISelectionProvider)this.textEditor.getAdapter(RevisionSelectionProvider.class);
            if (provider != null) {
                final ISelectionChangedListener selectionListener = event -> {
                    BuiltInAnnotateRevision selected;
                    if (event.getSelection() instanceof IStructuredSelection && (selected = (BuiltInAnnotateRevision)((Object)((Object)((IStructuredSelection)event.getSelection()).getFirstElement()))) != null && this.historyPage != null) {
                        this.historyPage.selectRevision(Long.parseLong(selected.getId()));
                    }
                };
                provider.addSelectionChangedListener(selectionListener);
                page.addPartListener(new IPartListener(){

                    public void partClosed(IWorkbenchPart part) {
                        if (part instanceof IHistoryView || part == BuiltInAnnotate.this.textEditor) {
                            page.removePartListener((IPartListener)this);
                            provider.removeSelectionChangedListener(selectionListener);
                        }
                    }

                    public void partActivated(IWorkbenchPart part) {
                    }

                    public void partBroughtToTop(IWorkbenchPart part) {
                    }

                    public void partDeactivated(IWorkbenchPart part) {
                    }

                    public void partOpened(IWorkbenchPart part) {
                    }
                });
            }
            this.textEditor.showRevisionInformation(info, SVNTeamQuickDiffProvider.class.getName());
        }
    }

    protected IEditorPart openEditor(IWorkbenchPage page, IRepositoryResource remote) throws PartInitException {
        int openType = 0;
        String openWith = null;
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(remote.getName());
        if (descriptor == null || !descriptor.isInternal()) {
            openType = 0;
            openWith = "org.eclipse.ui.DefaultTextEditor";
        } else {
            openType = 3;
            openWith = descriptor.getId();
        }
        OpenRemoteFileOperation op = new OpenRemoteFileOperation(new IRepositoryFile[]{(IRepositoryFile)remote}, openType, openWith);
        op.setRequiredDefaultEditorKind(AbstractDecoratedTextEditor.class);
        ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)new NullProgressMonitor());
        if (op.getExecutionState() == 0) {
            IEditorPart part = op.getEditors()[0];
            return this.findTextEditorPart(page, part, (IEditorInput)op.getRepositoryEditorInputs()[0]);
        }
        return null;
    }

    protected IEditorPart openEditor(IWorkbenchPage page, IFile resource) throws PartInitException {
        return RevisionAnnotationController.openEditor((IWorkbenchPage)page, (IFile)resource);
    }

    protected AbstractDecoratedTextEditor findTextEditorPart(IWorkbenchPage page, IEditorPart editor, IEditorInput input) {
        if (editor instanceof AbstractDecoratedTextEditor) {
            return (AbstractDecoratedTextEditor)editor;
        }
        if (editor instanceof MultiPageEditorPart) {
            IEditorPart[] parts;
            MultiPageEditorPart mpep = (MultiPageEditorPart)editor;
            IEditorPart[] iEditorPartArray = parts = mpep.findEditors(input);
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart editorPart = iEditorPartArray[n2];
                if (editorPart instanceof AbstractDecoratedTextEditor) {
                    page.activate((IWorkbenchPart)mpep);
                    mpep.setActiveEditor(editorPart);
                    return (AbstractDecoratedTextEditor)editorPart;
                }
                ++n2;
            }
        }
        return null;
    }
}

