/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class ExportOperation
extends AbstractRepositoryOperation {
    protected String path;
    protected SVNDepth depth;
    protected boolean ignoreExternals;

    public ExportOperation(IRepositoryResource[] resources, String path, SVNDepth depth, boolean ignoreExternals) {
        super("Operation_ExportRevision", SVNMessages.class, resources);
        this.path = path;
        this.depth = depth;
        this.ignoreExternals = ignoreExternals;
    }

    public ExportOperation(IRepositoryResourceProvider provider, String path, SVNDepth depth, boolean ignoreExternals) {
        super("Operation_ExportRevision", SVNMessages.class, provider);
        this.path = path;
        this.depth = depth;
        this.ignoreExternals = ignoreExternals;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] resources = this.operableData();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            IRepositoryLocation location = resources[i].getRepositoryLocation();
            ISVNConnector proxy = location.acquireSVNProxy();
            String path = this.path + "/" + resources[i].getName();
            SVNEntryRevisionReference entryRef = SVNUtility.getEntryRevisionReference(resources[i]);
            this.writeToConsole(0, "svn export \"" + resources[i].getUrl() + "@" + String.valueOf(resources[i].getPegRevision()) + "\" -r " + String.valueOf(resources[i].getSelectedRevision()) + " \"" + FileUtility.normalizePath(path) + "\"" + SVNUtility.getDepthArg(this.depth, 0L) + ISVNConnector.Options.asCommandLine(4L | (this.ignoreExternals ? 1L : 0L)) + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            this.protectStep(monitor1 -> {
                long options = 4L;
                if (this.ignoreExternals) {
                    options |= 1L;
                }
                proxy.exportTo(entryRef, path, null, this.depth, options, new SVNProgressMonitor(this, monitor1, null));
            }, monitor, resources.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }

    @Override
    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.operableData()[0].getUrl()});
    }
}

