/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class CreatePatchOperation
extends AbstractRepositoryOperation {
    protected String fileName;
    protected boolean recurse;
    protected long options;
    protected long diffOptions;

    public CreatePatchOperation(IRepositoryResource first, IRepositoryResource second, String fileName, boolean recurse, boolean ignoreDeleted, boolean processBinary) {
        this(first, second, fileName, recurse, ignoreDeleted, processBinary, true);
    }

    public CreatePatchOperation(IRepositoryResource first, IRepositoryResource second, String fileName, boolean recurse, boolean ignoreDeleted, boolean processBinary, boolean ignoreAncestry) {
        this(first, second, fileName, recurse, (ignoreDeleted ? 8192L : 0L) | (processBinary ? 4L : 0L) | (ignoreAncestry ? 512L : 0L), 0L);
    }

    public CreatePatchOperation(IRepositoryResource first, IRepositoryResource second, String fileName, boolean recurse, long options, long diffOptions) {
        super("Operation_CreatePatchRemote", SVNMessages.class, new IRepositoryResource[]{first, second});
        this.fileName = fileName;
        this.recurse = recurse;
        this.options = options & 0xFFFFFFFFC0002204L;
        this.diffOptions = diffOptions;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource first = this.operableData()[0];
        IRepositoryResource second = this.operableData()[1];
        IRepositoryLocation location = first.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            SVNEntryRevisionReference ref1 = SVNUtility.getEntryRevisionReference(first);
            SVNEntryRevisionReference ref2 = SVNUtility.getEntryRevisionReference(second);
            if (SVNUtility.useSingleReferenceSignature(ref1, ref2)) {
                this.writeToConsole(0, "svn diff -r " + String.valueOf(ref1.revision) + ":" + String.valueOf(ref2.revision) + " \"" + first.getUrl() + "@" + String.valueOf(ref1.pegRevision) + "\"" + (this.recurse ? "" : " -N") + ISVNConnector.Options.asCommandLine(this.options) + ISVNConnector.DiffOptions.asCommandLine(this.diffOptions) + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                proxy.diff((SVNEntryReference)ref1, new SVNRevisionRange(ref1.revision, ref2.revision), null, this.fileName, this.recurse ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES, this.options, null, this.diffOptions, (ISVNProgressMonitor)new SVNProgressMonitor(this, monitor, null));
            } else {
                this.writeToConsole(0, "svn diff \"" + first.getUrl() + "@" + String.valueOf(first.getSelectedRevision()) + "\" \"" + second.getUrl() + "@" + String.valueOf(second.getSelectedRevision()) + "\"" + (this.recurse ? "" : " -N") + ISVNConnector.Options.asCommandLine(this.options) + ISVNConnector.DiffOptions.asCommandLine(this.diffOptions) + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                proxy.diffTwo(ref1, ref2, null, this.fileName, this.recurse ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES, this.options, null, this.diffOptions, (ISVNProgressMonitor)new SVNProgressMonitor(this, monitor, null));
            }
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }
}

