/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.management;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamProvider;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;

public class FindRelatedProjectsOperation
extends AbstractActionOperation
implements IResourceProvider {
    protected IRepositoryLocation location;
    protected List<IProject> resources;
    protected Set<IProject> exceptProjects;

    public FindRelatedProjectsOperation(IRepositoryLocation location) {
        this(location, null);
    }

    public FindRelatedProjectsOperation(IRepositoryLocation location, IProject[] exceptProjects) {
        super("Operation_FindRelatedProjects", SVNMessages.class);
        this.location = location;
        if (exceptProjects != null) {
            this.exceptProjects = new HashSet<IProject>(Arrays.asList(exceptProjects));
        }
    }

    @Override
    public IResource[] getResources() {
        return this.resources == null ? new IProject[]{} : (IResource[])this.resources.toArray(new IProject[this.resources.size()]);
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.resources = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length && !monitor.isCanceled()) {
            IProject current = projects[i];
            this.protectStep(monitor1 -> {
                SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)current, (String)"org.eclipse.team.svn.core.svnnature");
                if (!(provider == null || this.exceptProjects != null && this.exceptProjects.contains(current) || provider.peekAtLocation() != this.location)) {
                    this.resources.add(current);
                }
            }, monitor, projects.length);
            ++i;
        }
    }
}

