/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.SVNResourceRuleFactory;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class RefreshResourcesOperation
extends AbstractWorkingCopyOperation {
    public static int REFRESH_CACHE = 0;
    public static int REFRESH_CHANGES = 1;
    public static int REFRESH_ALL = 2;
    protected int depth;
    protected int refreshType;
    protected boolean ignoreNestedProjects;

    public RefreshResourcesOperation(IResource[] resources) {
        this(resources, false);
    }

    public RefreshResourcesOperation(IResource[] resources, boolean ignoreNestedProjects) {
        this(resources, 2, REFRESH_CHANGES, ignoreNestedProjects);
    }

    public RefreshResourcesOperation(IResource[] resources, int depth, int refreshType) {
        this(resources, depth, refreshType, false);
    }

    public RefreshResourcesOperation(IResource[] resources, int depth, int refreshType, boolean ignoreNestedProjects) {
        super("Operation_RefreshResources", SVNMessages.class, resources);
        this.depth = depth;
        this.refreshType = refreshType;
        this.ignoreNestedProjects = ignoreNestedProjects;
    }

    public RefreshResourcesOperation(IResourceProvider provider) {
        this(provider, 2, REFRESH_CHANGES);
    }

    public RefreshResourcesOperation(IResourceProvider provider, int depth, int refreshType) {
        this(provider, depth, refreshType, false);
    }

    public RefreshResourcesOperation(IResourceProvider provider, int depth, int refreshType, boolean ignoreNestedProjects) {
        super("Operation_RefreshResources", SVNMessages.class, provider);
        this.depth = depth;
        this.refreshType = refreshType;
        this.ignoreNestedProjects = ignoreNestedProjects;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        ISchedulingRule rule = super.getSchedulingRule();
        if (this.ignoreNestedProjects || rule == ResourcesPlugin.getWorkspace().getRoot()) {
            return rule;
        }
        IResource[] resources = this.operableData();
        HashSet<ISchedulingRule> ruleSet = new HashSet<ISchedulingRule>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            ruleSet.add(SVNResourceRuleFactory.INSTANCE.refreshRule(element));
            ++n2;
        }
        return new MultiRule(ruleSet.toArray(new ISchedulingRule[ruleSet.size()]));
    }

    @Override
    protected IResource[] operableData() {
        IResource[] resources = super.operableData();
        if (this.ignoreNestedProjects) {
            return resources;
        }
        return this.mindNestedProject(resources);
    }

    protected IResource[] mindNestedProject(IResource[] resources) {
        HashSet<IProject> resourceSet = new HashSet<IProject>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            URI uri = element.getLocationURI();
            if (uri != null) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                Collections.addAll(resourceSet, element.getType() != 1 ? root.findContainersForLocationURI(uri) : root.findFilesForLocationURI(uri));
                IPath path = FileUtility.getResourcePath(element);
                IProject[] iProjectArray = root.getProjects();
                int n3 = iProjectArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProject resource = iProjectArray[n4];
                    if (path.isPrefixOf(FileUtility.getResourcePath((IResource)resource)) && this.depth != 0) {
                        resourceSet.add(resource);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return resourceSet.toArray(new IResource[resourceSet.size()]);
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] withNested;
        IResource[] original = this.operableData();
        if (original.length == 0) {
            return;
        }
        int tDepth = this.depth;
        if (tDepth != 0) {
            boolean allFiles = true;
            IResource[] iResourceArray = original;
            int n = original.length;
            int n2 = 0;
            while (n2 < n) {
                IResource element = iResourceArray[n2];
                allFiles &= element.getType() == 1;
                ++n2;
            }
            if (allFiles) {
                tDepth = 0;
            }
        }
        IResource[] resources = this.depth == 2 ? FileUtility.shrinkChildNodes(original) : original;
        boolean isPriorToSVN17 = SVNUtility.isPriorToSVN17();
        if (this.refreshType != REFRESH_CACHE) {
            ResourcesPlugin.getWorkspace().run(monitor2 -> {
                int i = 0;
                while (i < resources.length && !monitor2.isCanceled()) {
                    ProgressMonitorUtility.setTaskInfo(monitor2, this, resources[i].getName());
                    IResource resource = resources[i];
                    this.protectStep(monitor1 -> {
                        if (isPriorToSVN17) {
                            if (resource.getType() != 1 && this.depth != 2) {
                                this.refreshMetaInfo((IContainer)resource, monitor1);
                            }
                            if (resource.getType() != 4) {
                                this.refreshMetaInfo(resource.getParent(), monitor1);
                            }
                        }
                        this.doRefresh(resource, this.depth, monitor1);
                    }, monitor2, resources.length);
                    ++i;
                }
            }, null, 1, monitor);
        }
        if (this.refreshType != REFRESH_CHANGES || !isPriorToSVN17) {
            SVNRemoteStorage.instance().refreshLocalResources(resources, this.depth);
            IResource[] roots = FileUtility.getPathNodes(resources);
            SVNRemoteStorage.instance().fireResourceStatesChangedEvent(new ResourceStatesChangedEvent(roots, 0, 1));
            SVNRemoteStorage.instance().fireResourceStatesChangedEvent(new ResourceStatesChangedEvent(original, tDepth, 0));
        }
        if (this.ignoreNestedProjects && (withNested = this.mindNestedProject(original)).length != original.length) {
            ProgressMonitorUtility.doTaskScheduledDefault(new RefreshResourcesOperation(withNested, this.depth, this.refreshType), true);
        }
    }

    protected void refreshMetaInfo(IContainer container, IProgressMonitor monitor) throws CoreException {
        IResource metaInfo = container.findMember(SVNUtility.getSVNFolderName());
        if (metaInfo != null) {
            this.doRefresh(metaInfo, 2, monitor);
        }
    }

    protected void doRefresh(IResource resource, int depth, IProgressMonitor monitor) throws CoreException {
        try {
            resource.refreshLocal(depth, monitor);
        }
        catch (CoreException ex) {
            if (ex.getStatus() != null && ex.getStatus().toString().indexOf("(.project)") != -1) {
                throw new UnreportableException(SVNMessages.Operation_RefreshResources_DamagedProjectFile);
            }
            throw ex;
        }
    }
}

