/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNConflictResolution;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;

public class MarkResolvedOperation
extends AbstractWorkingCopyOperation {
    protected SVNConflictResolution.Choice conflictResult;
    protected SVNDepth depth;

    public MarkResolvedOperation(IResource[] resources, SVNConflictResolution.Choice conflictResult, SVNDepth depth) {
        super("Operation_MarkResolved", SVNMessages.class, resources);
        this.conflictResult = conflictResult;
        this.depth = depth;
    }

    public MarkResolvedOperation(IResourceProvider provider, SVNConflictResolution.Choice conflictResult, SVNDepth depth) {
        super("Operation_MarkResolved", SVNMessages.class, provider);
        this.conflictResult = conflictResult;
        this.depth = depth;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(resources[i]);
            String path = FileUtility.getWorkingCopyPath(resources[i]);
            ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(monitor1 -> proxy.resolve(path, this.conflictResult, this.depth, new SVNProgressMonitor(this, monitor1, null)), monitor, resources.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }
}

