/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.local.property.GetPropertiesOperation;
import org.eclipse.team.svn.core.operation.remote.GetRemotePropertiesOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class DiffViewerSettings {
    public static ResourceSpecificParameterKind DEFAULT_RESOURCE_SPECIFIC_PARAMETER_KIND = new ResourceSpecificParameterKind(ResourceSpecificParameterKindEnum.DEFAULT, "*");
    protected Map<ResourceSpecificParameterKind, ResourceSpecificParameters> specificParameters = new HashMap<ResourceSpecificParameterKind, ResourceSpecificParameters>();
    protected ListenerList listenersList = new ListenerList();

    public static ResourceSpecificParameterKind getSpecificResourceKind(DiffViewerSettings diffSettings, IFile file, IProgressMonitor monitor) {
        ResourceSpecificParameterKind tmpKind;
        ResourceSpecificParameterKind kind = null;
        String fileExtension = file.getFileExtension();
        if (fileExtension != null && diffSettings.specificParameters.containsKey(tmpKind = new ResourceSpecificParameterKind(ResourceSpecificParameterKindEnum.FILE_EXTENSION, fileExtension))) {
            kind = tmpKind;
        }
        if (kind == null) {
            String mimeType = null;
            if (IStateFilter.SF_VERSIONED.accept(SVNRemoteStorage.instance().asLocalResource((IResource)file))) {
                SVNProperty[] props;
                GetPropertiesOperation op = new GetPropertiesOperation((IResource)file);
                ProgressMonitorUtility.doTaskExternalDefault(op, monitor);
                if (op.getExecutionState() == 0 && (props = op.getProperties()) != null) {
                    SVNProperty[] sVNPropertyArray = props;
                    int n = props.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SVNProperty prop = sVNPropertyArray[n2];
                        if ("svn:mime-type".equals(prop.name)) {
                            mimeType = prop.value;
                            break;
                        }
                        ++n2;
                    }
                }
            }
            if (mimeType != null && diffSettings.specificParameters.containsKey(tmpKind = new ResourceSpecificParameterKind(ResourceSpecificParameterKindEnum.MIME_TYPE, mimeType))) {
                kind = tmpKind;
            }
        }
        return kind;
    }

    public static ResourceSpecificParameterKind getSpecificResourceKind(DiffViewerSettings diffSettings, IRepositoryFile file, IProgressMonitor monitor) {
        ResourceSpecificParameterKind tmpKind;
        ResourceSpecificParameterKind kind = null;
        String fileExtension = null;
        String fileName = file.getName();
        int index = fileName.lastIndexOf(".");
        if (index != -1 && index != fileName.length() && diffSettings.specificParameters.containsKey(tmpKind = new ResourceSpecificParameterKind(ResourceSpecificParameterKindEnum.FILE_EXTENSION, fileExtension = fileName.substring(index + 1)))) {
            kind = tmpKind;
        }
        if (kind == null) {
            ResourceSpecificParameterKind tmpKind2;
            SVNProperty[] props;
            String mimeType = null;
            GetRemotePropertiesOperation op = new GetRemotePropertiesOperation(file);
            ProgressMonitorUtility.doTaskExternalDefault(op, monitor);
            if (op.getExecutionState() == 0 && (props = op.getProperties()) != null) {
                SVNProperty[] sVNPropertyArray = props;
                int n = props.length;
                int n2 = 0;
                while (n2 < n) {
                    SVNProperty prop = sVNPropertyArray[n2];
                    if ("svn:mime-type".equals(prop.name)) {
                        mimeType = prop.value;
                        break;
                    }
                    ++n2;
                }
            }
            if (mimeType != null && diffSettings.specificParameters.containsKey(tmpKind2 = new ResourceSpecificParameterKind(ResourceSpecificParameterKindEnum.MIME_TYPE, mimeType))) {
                kind = tmpKind2;
            }
        }
        return kind;
    }

    public boolean addResourceSpecificParameters(ResourceSpecificParameterKindEnum kindEnum, String kindValue, ExternalProgramParameters params) {
        return this.addResourceSpecificParameters(kindEnum, kindValue, params, true);
    }

    public boolean addResourceSpecificParameters(ResourceSpecificParameterKindEnum kindEnum, String kindValue, ExternalProgramParameters params, boolean isEnabled) {
        ResourceSpecificParameterKind kind = new ResourceSpecificParameterKind(kindEnum, kindValue);
        ResourceSpecificParameters resourceParams = new ResourceSpecificParameters(kind, params, isEnabled);
        return this.addResourceSpecificParameters(resourceParams);
    }

    public boolean addResourceSpecificParameters(ResourceSpecificParameters resourceParams) {
        boolean isAdded = false;
        if (!this.specificParameters.containsKey(resourceParams.kind)) {
            this.specificParameters.put(resourceParams.kind, resourceParams);
            isAdded = true;
            if (!this.listenersList.isEmpty()) {
                Object[] listeners;
                Object[] objectArray = listeners = this.listenersList.getListeners();
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener2 = objectArray[n2];
                    IDiffViewerChangeListener listener = (IDiffViewerChangeListener)listener2;
                    listener.addResourceSpecificParameters(resourceParams);
                    ++n2;
                }
            }
        }
        return isAdded;
    }

    public void removeResourceSpecificParameters(ResourceSpecificParameters resourceParams) {
        this.specificParameters.remove(resourceParams.kind);
        if (!this.listenersList.isEmpty()) {
            Object[] listeners;
            Object[] objectArray = listeners = this.listenersList.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener2 = objectArray[n2];
                IDiffViewerChangeListener listener = (IDiffViewerChangeListener)listener2;
                listener.removeResourceSpecificParameters(resourceParams);
                ++n2;
            }
        }
    }

    public void updateResourceSpecificParameters(ResourceSpecificParameters resourceParams) {
        if (!this.listenersList.isEmpty()) {
            Object[] listeners;
            Object[] objectArray = listeners = this.listenersList.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener2 = objectArray[n2];
                IDiffViewerChangeListener listener = (IDiffViewerChangeListener)listener2;
                listener.changeResourceSpecificParameters(resourceParams);
                ++n2;
            }
        }
    }

    public ResourceSpecificParameters getResourceSpecificParameters(ResourceSpecificParameterKind kind) {
        return this.specificParameters.get(kind);
    }

    public ResourceSpecificParameters[] getResourceSpecificParameters() {
        return this.specificParameters.values().toArray(new ResourceSpecificParameters[0]);
    }

    public ResourceSpecificParameters getDefaultResourceSpecificParameters() {
        return this.specificParameters.get(DEFAULT_RESOURCE_SPECIFIC_PARAMETER_KIND);
    }

    public static DiffViewerSettings getDefaultDiffViewerSettings() {
        DiffViewerSettings diffSettings = new DiffViewerSettings();
        if (FileUtility.isWindows()) {
            String diffProgramPath = "wscript.exe";
            String diffParametersString = "\"${default-doc-program}\" \"${base}\" \"${mine}\" //E:vbscript";
            String mergeProgramPath = "wscript.exe";
            String mergeParametersString = "\"${default-doc-program}\" \"${theirs}\" \"${mine}\" //E:vbscript";
            diffSettings.addResourceSpecificParameters(ResourceSpecificParameterKindEnum.FILE_EXTENSION, "doc", new ExternalProgramParameters(diffProgramPath, mergeProgramPath, diffParametersString, mergeParametersString));
            diffProgramPath = "wscript.exe";
            diffParametersString = "\"${default-doc-program}\" \"${base}\" \"${mine}\" //E:vbscript";
            mergeProgramPath = "wscript.exe";
            mergeParametersString = "\"${default-doc-program}\" \"${theirs}\" \"${mine}\" //E:vbscript";
            diffSettings.addResourceSpecificParameters(ResourceSpecificParameterKindEnum.FILE_EXTENSION, "docx", new ExternalProgramParameters(diffProgramPath, mergeProgramPath, diffParametersString, mergeParametersString));
            diffProgramPath = "wscript.exe";
            diffParametersString = "\"${default-xls-program}\" \"${base}\" \"${mine}\" //E:vbscript";
            mergeProgramPath = null;
            mergeParametersString = null;
            diffSettings.addResourceSpecificParameters(ResourceSpecificParameterKindEnum.FILE_EXTENSION, "xls", new ExternalProgramParameters(diffProgramPath, mergeProgramPath, diffParametersString, mergeParametersString));
            diffProgramPath = "wscript.exe";
            diffParametersString = "\"${default-xls-program}\" \"${base}\" \"${mine}\" //E:vbscript";
            mergeProgramPath = null;
            mergeParametersString = null;
            diffSettings.addResourceSpecificParameters(ResourceSpecificParameterKindEnum.FILE_EXTENSION, "xlsx", new ExternalProgramParameters(diffProgramPath, mergeProgramPath, diffParametersString, mergeParametersString));
            diffProgramPath = "wscript.exe";
            diffParametersString = "\"${default-ppt-program}\" \"${base}\" \"${mine}\" //E:vbscript";
            mergeProgramPath = null;
            mergeParametersString = null;
            diffSettings.addResourceSpecificParameters(ResourceSpecificParameterKindEnum.FILE_EXTENSION, "ppt", new ExternalProgramParameters(diffProgramPath, mergeProgramPath, diffParametersString, mergeParametersString));
            diffProgramPath = "wscript.exe";
            diffParametersString = "\"${default-ppt-program}\" \"${base}\" \"${mine}\" //E:vbscript";
            mergeProgramPath = null;
            mergeParametersString = null;
            diffSettings.addResourceSpecificParameters(ResourceSpecificParameterKindEnum.FILE_EXTENSION, "pptx", new ExternalProgramParameters(diffProgramPath, mergeProgramPath, diffParametersString, mergeParametersString));
            diffProgramPath = "wscript.exe";
            diffParametersString = "\"${default-odt-program}\" \"${base}\" \"${mine}\" //E:vbscript";
            mergeProgramPath = "wscript.exe";
            mergeParametersString = "\"${default-odt-program}\" \"${theirs}\" \"${mine}\" //E:vbscript";
            diffSettings.addResourceSpecificParameters(ResourceSpecificParameterKindEnum.FILE_EXTENSION, "odt", new ExternalProgramParameters(diffProgramPath, mergeProgramPath, diffParametersString, mergeParametersString));
            diffProgramPath = "wscript.exe";
            diffParametersString = "\"${default-ods-program}\" \"${base}\" \"${mine}\" //E:vbscript";
            mergeProgramPath = "wscript.exe";
            mergeParametersString = "\"${default-ods-program}\" \"${theirs}\" \"${mine}\" //E:vbscript";
            diffSettings.addResourceSpecificParameters(ResourceSpecificParameterKindEnum.FILE_EXTENSION, "ods", new ExternalProgramParameters(diffProgramPath, mergeProgramPath, diffParametersString, mergeParametersString));
        }
        return diffSettings;
    }

    public void addChangeListener(IDiffViewerChangeListener listener) {
        this.listenersList.add((Object)listener);
    }

    public void removeChangeListener(IDiffViewerChangeListener listener) {
        this.listenersList.remove((Object)listener);
    }

    public static class ExternalProgramParameters {
        public String diffProgramPath;
        public String diffParamatersString;
        public String mergeProgramPath;
        public String mergeParamatersString;

        public ExternalProgramParameters(String diffProgramPath, String mergeProgramPath, String diffParamatersString, String mergeParamatersString) {
            this.diffProgramPath = diffProgramPath;
            this.mergeProgramPath = mergeProgramPath;
            this.diffParamatersString = diffParamatersString;
            this.mergeParamatersString = mergeParamatersString;
        }
    }

    public static interface IDiffViewerChangeListener {
        public void addResourceSpecificParameters(ResourceSpecificParameters var1);

        public void removeResourceSpecificParameters(ResourceSpecificParameters var1);

        public void changeResourceSpecificParameters(ResourceSpecificParameters var1);
    }

    public static class ResourceSpecificParameterKind {
        public ResourceSpecificParameterKindEnum kindEnum;
        public String kindValue;

        public ResourceSpecificParameterKind(ResourceSpecificParameterKindEnum kindEnum, String kindValue) {
            this.kindEnum = kindEnum;
            this.kindValue = kindValue;
        }

        public boolean equals(Object ob) {
            boolean isEqual = false;
            if (ob != null && ob instanceof ResourceSpecificParameterKind) {
                ResourceSpecificParameterKind kind = (ResourceSpecificParameterKind)ob;
                if (this.kindEnum == kind.kindEnum && this.kindValue.equals(kind.kindValue)) {
                    isEqual = true;
                }
            }
            return isEqual;
        }

        public String formatKindValue() {
            Object res = this.kindValue;
            if (ResourceSpecificParameterKindEnum.FILE_EXTENSION.equals((Object)this.kindEnum)) {
                res = "." + this.kindValue;
            }
            return res;
        }

        public static ResourceSpecificParameterKind getKind(String kindString) {
            String kindValue = null;
            ResourceSpecificParameterKindEnum kindEnum = null;
            if (kindString.startsWith(".")) {
                kindEnum = ResourceSpecificParameterKindEnum.FILE_EXTENSION;
                kindValue = kindString.substring(1);
            } else if (DiffViewerSettings.DEFAULT_RESOURCE_SPECIFIC_PARAMETER_KIND.kindValue.equals(kindString)) {
                kindEnum = DiffViewerSettings.DEFAULT_RESOURCE_SPECIFIC_PARAMETER_KIND.kindEnum;
                kindValue = DiffViewerSettings.DEFAULT_RESOURCE_SPECIFIC_PARAMETER_KIND.kindValue;
            } else {
                kindEnum = ResourceSpecificParameterKindEnum.MIME_TYPE;
                kindValue = kindString;
            }
            ResourceSpecificParameterKind kind = new ResourceSpecificParameterKind(kindEnum, kindValue);
            return kind;
        }

        public int hashCode() {
            return this.kindEnum.hashCode() + this.kindValue.hashCode();
        }
    }

    public static enum ResourceSpecificParameterKindEnum {
        MIME_TYPE,
        FILE_EXTENSION,
        DEFAULT;

    }

    public static class ResourceSpecificParameters {
        public static final int FIELDS_COUNT = 7;
        public ResourceSpecificParameterKind kind;
        public ExternalProgramParameters params;
        public boolean isEnabled;

        public ResourceSpecificParameters(ResourceSpecificParameterKindEnum kindEnum, String kindValue, String diffProgramPath, String mergeProgramPath, String diffProgramParams, String mergeProgramParams) {
            this(new ResourceSpecificParameterKind(kindEnum, kindValue), new ExternalProgramParameters(diffProgramPath, mergeProgramPath, diffProgramParams, mergeProgramParams));
        }

        public ResourceSpecificParameters(ResourceSpecificParameterKind kind, ExternalProgramParameters params) {
            this(kind, params, true);
        }

        public ResourceSpecificParameters(ResourceSpecificParameterKind kind, ExternalProgramParameters params, boolean isEnabled) {
            this.kind = kind;
            this.params = params;
            this.isEnabled = isEnabled;
        }

        public String[] getAsStrings() {
            String[] res = new String[]{this.isEnabled ? "1" : "0", this.kind.kindEnum.name(), this.kind.kindValue == null ? "" : this.kind.kindValue, this.params.diffProgramPath == null ? "" : this.params.diffProgramPath, this.params.mergeProgramPath == null ? "" : this.params.mergeProgramPath, this.params.diffParamatersString == null ? "" : this.params.diffParamatersString, this.params.mergeParamatersString == null ? "" : this.params.mergeParamatersString};
            return res;
        }

        public static ResourceSpecificParameters createFromStrings(String[] strings) {
            ResourceSpecificParameterKindEnum[] kindEnums;
            if (strings.length != 7) {
                return null;
            }
            boolean isEnabled = "1".equals(strings[0]);
            ResourceSpecificParameterKindEnum kindEnum = null;
            ResourceSpecificParameterKindEnum[] resourceSpecificParameterKindEnumArray = kindEnums = ResourceSpecificParameterKindEnum.values();
            int n = kindEnums.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceSpecificParameterKindEnum ke = resourceSpecificParameterKindEnumArray[n2];
                if (ke.name().equals(strings[1])) {
                    kindEnum = ke;
                    break;
                }
                ++n2;
            }
            ResourceSpecificParameters res = new ResourceSpecificParameters(kindEnum, strings[2], strings[3], strings[4], strings[5], strings[6]);
            res.isEnabled = isEnabled;
            return res;
        }
    }
}

