/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.utility.FileUtility;

public class UpgradeWorkingCopyOperation
extends AbstractFileOperation {
    public UpgradeWorkingCopyOperation(File[] files) {
        super("Operation_Upgrade", SVNMessages.class, files);
    }

    public UpgradeWorkingCopyOperation(IFileProvider provider) {
        super("Operation_Upgrade", SVNMessages.class, provider);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        files = FileUtility.shrinkChildNodes(files, false);
        ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().createConnector();
        try {
            block6: {
                int i;
                block5: {
                    i = 0;
                    if (!true) break block5;
                    if (i >= files.length) return;
                    if (monitor.isCanceled()) break block6;
                }
                do {
                    File current = files[i];
                    this.writeToConsole(0, "svn upgrade \"" + FileUtility.normalizePath(current.getAbsolutePath()) + "\"\n");
                    this.protectStep(monitor1 -> proxy.upgrade(current.getAbsolutePath(), new SVNProgressMonitor(this, monitor1, null)), monitor, files.length);
                    ++i;
                    if (i >= files.length) return;
                } while (!monitor.isCanceled());
            }
            return;
        }
        finally {
            proxy.dispose();
        }
    }
}

