/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.SVNConflictDetectionProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileConflictDetectionOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class UpdateOperation
extends AbstractFileConflictDetectionOperation
implements IFileProvider {
    protected SVNRevision selectedRevision;
    protected long options;
    protected SVNDepth depth;
    protected String updateDepthPath;

    public UpdateOperation(File[] files, SVNRevision selectedRevision, boolean ignoreExternals) {
        this(files, selectedRevision, SVNDepth.INFINITY, ignoreExternals ? 1L : 0L, null);
    }

    public UpdateOperation(IFileProvider provider, SVNRevision selectedRevision, boolean ignoreExternals) {
        this(provider, selectedRevision, SVNDepth.INFINITY, ignoreExternals ? 1L : 0L, null);
    }

    public UpdateOperation(File[] files, SVNRevision selectedRevision, SVNDepth depth, long options, String updateDepthPath) {
        super("Operation_UpdateFile", SVNMessages.class, files);
        this.selectedRevision = selectedRevision;
        this.options = options & 0x4003L;
        this.depth = depth;
        this.updateDepthPath = updateDepthPath;
    }

    public UpdateOperation(IFileProvider provider, SVNRevision selectedRevision, SVNDepth depth, long options, String updateDepthPath) {
        super("Operation_UpdateFile", SVNMessages.class, provider);
        this.selectedRevision = selectedRevision;
        this.options = options & 0x4003L;
        this.depth = depth;
        this.updateDepthPath = updateDepthPath;
    }

    public void setDepthOptions(SVNDepth depth, boolean isStickyDepth, String updateDepthPath) {
        this.depth = depth;
        this.options &= 0xFFFFFFFFFFFFBFFFL;
        this.options |= isStickyDepth ? 16384L : 0L;
        this.updateDepthPath = updateDepthPath;
    }

    @Override
    public File[] getFiles() {
        return this.getProcessed();
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        this.defineInitialResourceSet(files);
        Map wc2Resources = SVNUtility.splitWorkingCopies(files);
        Iterator it = wc2Resources.entrySet().iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            Map.Entry entry = it.next();
            IRepositoryResource wcRoot = SVNFileStorage.instance().asRepositoryResource((File)entry.getKey(), false);
            IRepositoryLocation location = wcRoot.getRepositoryLocation();
            String[] paths = FileUtility.asPathArray(((List)entry.getValue()).toArray(new File[0]));
            if ((this.options & 0x4000L) != 0L && this.updateDepthPath != null && paths.length == 1) {
                Object newPath = paths[0] + "/" + this.updateDepthPath;
                paths[0] = newPath = FileUtility.normalizePath((String)newPath);
            }
            this.complexWriteToConsole(() -> {
                this.writeToConsole(0, "svn update" + ISVNConnector.Options.asCommandLine(this.options));
                int i = 0;
                while (i < paths.length && !monitor.isCanceled()) {
                    this.writeToConsole(0, " \"" + paths[i] + "\"");
                    ++i;
                }
                this.writeToConsole(0, " -r " + String.valueOf(this.selectedRevision) + SVNUtility.getDepthArg(this.depth, this.options) + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            });
            ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(monitor1 -> {
                long[] lArray = proxy.update(paths, this.selectedRevision, this.depth, this.options, new ConflictDetectionProgressMonitor(this, monitor1, null));
            }, monitor, wc2Resources.size());
            location.releaseSVNProxy(proxy);
        }
    }

    protected class ConflictDetectionProgressMonitor
    extends SVNConflictDetectionProgressMonitor {
        public ConflictDetectionProgressMonitor(IActionOperation parent, IProgressMonitor monitor, IPath root) {
            super(parent, monitor, root);
        }

        @Override
        protected void processConflict(ISVNProgressMonitor.ItemState state) {
            UpdateOperation.this.hasUnresolvedConflict = true;
            UpdateOperation.this.unprocessed.add(new File(state.path));
            Path conflictPath = new Path(state.path);
            Iterator it = UpdateOperation.this.processed.iterator();
            while (it.hasNext()) {
                File res = (File)it.next();
                if (!new Path(res.getAbsolutePath()).equals((Object)conflictPath)) continue;
                it.remove();
                break;
            }
        }
    }
}

