/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.connector;

import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNLock;

public class SVNNotification {
    public final String path;
    public final PerformedAction action;
    public final SVNEntry.Kind kind;
    public final String mimeType;
    public final SVNLock lock;
    public final String errMsg;
    public final NodeStatus contentState;
    public final NodeStatus propState;
    public final long revision;
    public final NodeLock lockState;

    public SVNNotification(String path, PerformedAction action, SVNEntry.Kind kind, String mimeType, SVNLock lock, String errMsg, NodeStatus contentState, NodeStatus propState, NodeLock lockState, long revision) {
        this.path = path;
        this.action = action;
        this.kind = kind;
        this.mimeType = mimeType;
        this.lock = lock;
        this.errMsg = errMsg;
        this.contentState = contentState;
        this.propState = propState;
        this.revision = revision;
        this.lockState = lockState;
    }

    public static enum NodeLock {
        INAPPLICABLE(0),
        UNKNOWN(1),
        UNCHANGED(2),
        LOCKED(3),
        UNLOCKED(4);

        public final int id;

        public static boolean isStatusKnown(int status) {
            return status >= NodeLock.INAPPLICABLE.id && status <= NodeLock.UNLOCKED.id;
        }

        public static NodeLock fromId(int id) {
            NodeLock[] nodeLockArray = NodeLock.values();
            int n = nodeLockArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeLock kind = nodeLockArray[n2];
                if (kind.id == id) {
                    return kind;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid lock kind: " + id);
        }

        private NodeLock(int id) {
            this.id = id;
        }
    }

    public static enum NodeStatus {
        INAPPLICABLE(0),
        UNKNOWN(1),
        UNCHANGED(2),
        MISSING(3),
        OBSTRUCTED(4),
        CHANGED(5),
        MERGED(6),
        CONFLICTED(7);

        public final int id;
        public static final String[] statusNames;
        public static final String[] shortStatusNames;

        static {
            statusNames = new String[]{"inapplicable", "unknown", "unchanged", "missing", "obstructed", "changed", "merged", "conflicted"};
            shortStatusNames = new String[]{" ", " ", " ", "?", "O", "U", "G", "C"};
        }

        public static boolean isStatusKnown(int status) {
            return status >= NodeStatus.INAPPLICABLE.id && status <= NodeStatus.CONFLICTED.id;
        }

        public static NodeStatus fromId(int id) {
            NodeStatus[] nodeStatusArray = NodeStatus.values();
            int n = nodeStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeStatus kind = nodeStatusArray[n2];
                if (kind.id == id) {
                    return kind;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid node status kind: " + id);
        }

        private NodeStatus(int id) {
            this.id = id;
        }
    }

    public static enum PerformedAction {
        _UNKNOWN_ACTION(-1),
        ADD(0),
        COPY(1),
        DELETE(2),
        RESTORE(3),
        REVERT(4),
        FAILED_REVERT(5),
        RESOLVED(6),
        SKIP(7),
        UPDATE_DELETE(8),
        UPDATE_ADD(9),
        UPDATE_UPDATE(10),
        UPDATE_COMPLETED(11),
        UPDATE_EXTERNAL(12),
        STATUS_COMPLETED(13),
        STATUS_EXTERNAL(14),
        COMMIT_MODIFIED(15),
        COMMIT_ADDED(16),
        COMMIT_DELETED(17),
        COMMIT_REPLACED(18),
        COMMIT_POSTFIX_TXDELTA(19),
        BLAME_REVISION(20),
        LOCKED(21),
        UNLOCKED(22),
        FAILED_LOCK(23),
        FAILED_UNLOCK(24),
        EXISTS(25),
        CHANGELIST_SET(26),
        CHANGELIST_CLEAR(27),
        MERGE_BEGIN(28),
        FOREIGN_MERGE_BEGIN(29),
        UPDATE_REPLACED(30),
        PROPERTY_ADDED(31),
        PROPERTY_MODIFIED(32),
        PROPERTY_DELETED(33),
        PROPERTY_DELETED_NONEXISTENT(34),
        REVPROP_SET(35),
        REVPROP_DELETE(36),
        MERGE_COMPLETED(37),
        TREE_CONFLICT(38),
        CHANGELIST_MOVED(39),
        FAILED_EXTERNAL(40),
        UPDATE_STARTED(41),
        UPDATE_SKIP_OBSTRUCTION(42),
        UPDATE_SKIP_WORKING_ONLY(43),
        UPDATE_SKIP_ACCESS_DENIED(44),
        UPDATE_EXTERNAL_REMOVED(45),
        UPDATE_SHADOWED_ADD(46),
        UPDATE_SHADOWED_UPDATE(47),
        UPDATE_SHADOWED_DELETE(48),
        MERGE_RECORD_INFO(49),
        UPGRADED_PATH(50),
        MERGE_RECORD_INFO_BEGIN(51),
        MERGE_ELIDE_INFO(52),
        PATCH(53),
        PATCH_APPLIED_HUNK(54),
        PATCH_REJECTED_HUNK(55),
        PATCH_HUNK_ALREADY_APPLIED(56),
        COMMIT_COPIED(57),
        COMMIT_COPIED_REPLACED(58),
        URL_REDIRECT(59),
        PATH_NONEXISTENT(60),
        EXCLUDE(61),
        FAILED_CONFLICT(62),
        FAILED_MISSING(63),
        FAILED_OUT_OF_DATE(64),
        FAILED_NO_PARENT(65),
        FAILED_LOCKED(66),
        FAILED_FORBIDDEN_BY_SERVER(67),
        SKIP_CONFLICTED(68),
        UPDATE_BROKEN_LOCK(69),
        FAILED_OBSTRUCTED(70),
        CONFLICT_RESOLVER_STARTING(71),
        CONFLICT_RESOLVER_DONE(72),
        LEFT_LOCAL_MODIFICATIONS(73),
        FOREIGN_COPY_BEGIN(74),
        MOVE_BROKEN(75);

        public final int id;
        public static final String[] actionNames;

        static {
            actionNames = new String[]{"add", "copy", "delete", "restore", "revert", "failed revert", "resolved", "skip", "update delete", "update add", "update modified", "update completed", "update external", "status completed", "status external", "sending modified", "sending added", "sending deleted", "sending replaced", "transfer", "blame revision processed", "locked", "unlocked", "locking failed", "unlocking failed", "path exists", "changelist set", "changelist cleared", "merge begin", "foreign merge begin", "replaced", "property added", "property modified", "property deleted", "nonexistent property deleted", "revprop set", "revprop deleted", "merge completed", "tree conflict", "changelist moved", "failed external", "update started", "update skip obstruction", "update skip working only", "update skip access denied", "update external removed", "update shadowed add", "update shadowed update", "update shadowed delete", "merge record info", "upgraded path", "merge record info begin", "Merge elide info", "patch", "patch applied hunk", "patch rejected hunk", "patch hunk already applied", "commit copied", "commit copied replaced", "url redirect", "path nonexistent", "exclude", "failed conflict", "failed missing", "failed out of date", "failed no parent", "failed by lock", "failed forbidden by server", "broken lock removed", "failed by obstruction", "conflict resolver starting", "conflict resolver done", "conflict resolver done", "foreign copy begin", "move broken"};
        }

        public static boolean isActionKnown(int action) {
            return action >= PerformedAction.ADD.id && action <= PerformedAction.MOVE_BROKEN.id;
        }

        public static PerformedAction fromId(int id) {
            PerformedAction[] performedActionArray = PerformedAction.values();
            int n = performedActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                PerformedAction kind = performedActionArray[n2];
                if (kind.id == id) {
                    return kind;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid action kind: " + id);
        }

        private PerformedAction(int id) {
            this.id = id;
        }
    }
}

