/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.copymove;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.RepositoryTreeComposite;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.panel.common.RepositoryTreePanel;
import org.eclipse.team.svn.ui.repository.model.RepositoryFile;
import org.eclipse.team.svn.ui.repository.model.RepositoryFolder;
import org.eclipse.team.svn.ui.repository.model.RepositoryLocationFilter;
import org.eclipse.team.svn.ui.repository.model.RepositoryResource;
import org.eclipse.team.svn.ui.repository.model.RepositoryRevisions;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.ResourceNameVerifier;
import org.eclipse.team.svn.ui.wizard.AbstractVerifiedWizardPage;

public class SelectDestinationPage
extends AbstractVerifiedWizardPage {
    protected IRepositoryResource[] resources;
    protected RepositoryTreeComposite repositoryTree;
    protected Text newResourceName;

    public SelectDestinationPage(IRepositoryResource[] resources) {
        super(SelectDestinationPage.class.getName(), SVNUIMessages.RepositoryTreePanel_Description, SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
        this.setDescription(AbstractDialogPanel.makeToBeOperatedMessage(resources) + "\r\n" + SVNUIMessages.AbstractCopyToMoveTo_Message);
        this.resources = resources;
    }

    @Override
    protected Composite createControlImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        this.repositoryTree = new RepositoryTreeComposite(composite, 2048, false, new RepositoryTreePanel.ProjectRoot(this.resources[0], false));
        RepositoryTreePanel.ProjectRoot root = (RepositoryTreePanel.ProjectRoot)this.repositoryTree.getRepositoryTreeViewer().getInput();
        this.repositoryTree.getRepositoryTreeViewer().setExpandedElements(new Object[]{root.getChildren(null)[0]});
        String url = this.resources[0].getRepositoryLocation().getRepositoryRootUrl();
        this.repositoryTree.setFilter(new RepositoryLocationFilter(url){

            @Override
            public boolean accept(Object obj) {
                if (obj instanceof RepositoryFile || obj instanceof RepositoryRevisions || obj instanceof RepositoryFolder && this.acceptYourself(((RepositoryFolder)obj).getRepositoryResource())) {
                    return false;
                }
                return super.accept(obj);
            }

            private boolean acceptYourself(IRepositoryResource resource) {
                IRepositoryResource[] iRepositoryResourceArray = SelectDestinationPage.this.resources;
                int n = SelectDestinationPage.this.resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IRepositoryResource element = iRepositoryResourceArray[n2];
                    if (resource.equals(element)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
        this.repositoryTree.setLayoutData(data);
        this.repositoryTree.getRepositoryTreeViewer().addSelectionChangedListener(event -> this.validateContent());
        data = new GridData();
        Label name = new Label(composite, 0);
        name.setText(this.resources.length == 1 ? SVNUIMessages.CopyMove_SubFolder_One : SVNUIMessages.CopyMove_SubFolder_Multi);
        name.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        this.newResourceName = new Text(composite, 2048);
        this.newResourceName.setLayoutData((Object)data);
        CompositeVerifier verifier = new CompositeVerifier();
        if (this.resources.length == 1) {
            verifier.add(new NonEmptyFieldVerifier(name.getText()));
            this.newResourceName.setText(this.resources[0].getName());
        }
        verifier.add(new ResourceNameVerifier(name.getText(), CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() >= 5));
        this.attachTo((Control)this.newResourceName, verifier);
        return composite;
    }

    @Override
    public boolean isPageComplete() {
        return super.isPageComplete() && !this.repositoryTree.getRepositoryTreeViewer().getSelection().isEmpty();
    }

    public IRepositoryResource getDestination() {
        IStructuredSelection sel = (IStructuredSelection)this.repositoryTree.getRepositoryTreeViewer().getSelection();
        return ((RepositoryResource)sel.getFirstElement()).getRepositoryResource();
    }

    public String getNewResourceName() {
        return this.newResourceName.getText();
    }
}

