/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.synchronize.UpdateSyncInfo;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.IResourceSelector;
import org.eclipse.team.svn.ui.dialog.TagModifyWarningDialog;
import org.eclipse.team.svn.ui.extension.ExtensionsManager;
import org.eclipse.team.svn.ui.extension.factory.ICommitDialog;
import org.eclipse.team.svn.ui.mapping.ModelHelper;
import org.eclipse.team.svn.ui.mapping.SVNModelParticipantChangeSetCapability;
import org.eclipse.team.svn.ui.panel.local.CommitPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.synchronize.SVNChangeSetCapability;
import org.eclipse.team.svn.ui.synchronize.action.AbstractActionHelper;
import org.eclipse.team.svn.ui.utility.CommitActionUtility;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class CommitActionHelper
extends AbstractActionHelper {
    public CommitActionHelper(IAction action, ISynchronizePageConfiguration configuration) {
        super(action, configuration);
    }

    @Override
    public IActionOperation getOperation() {
        return CommitActionHelper.getCommitOperation(this.getSyncInfoSelector(), this.configuration);
    }

    @Override
    public FastSyncInfoFilter getSyncInfoFilter() {
        return CommitActionHelper.getCommitSyncInfoFilter();
    }

    public static FastSyncInfoFilter getCommitSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4}){

            public boolean select(SyncInfo info) {
                UpdateSyncInfo sync = (UpdateSyncInfo)info;
                return super.select(info) && !IStateFilter.SF_OBSTRUCTED.accept(sync.getLocalResource());
            }
        };
    }

    public static IActionOperation getCommitOperation(IResourceSelector resourceSelector, ISynchronizePageConfiguration configuration) {
        TagModifyWarningDialog dlg;
        CommitActionUtility commitUtility = new CommitActionUtility(resourceSelector);
        IResource[] resources = commitUtility.getAllResources();
        IProject[] tagOperatedProjects = SVNUtility.getTagOperatedProjects((IResource[])resources);
        if (tagOperatedProjects.length != 0 && (dlg = new TagModifyWarningDialog(configuration.getSite().getShell(), tagOperatedProjects)).open() != 0) {
            return null;
        }
        String proposedComment = ModelHelper.isShowModelSync() ? SVNModelParticipantChangeSetCapability.getProposedComment(resources) : SVNChangeSetCapability.getProposedComment(resources);
        CommitPanel commitPanel = new CommitPanel(resources, resources, 0, proposedComment);
        ICommitDialog dialog = ExtensionsManager.getInstance().getCurrentCommitFactory().getCommitDialog(configuration.getSite().getShell(), commitUtility.getAllResourcesSet(), commitPanel);
        if (dialog.open() != 0) {
            return null;
        }
        return commitUtility.getCompositeCommitOperation(commitPanel.getSelectedResources(), commitPanel.getTreatAsEdits(), dialog.getMessage(), commitPanel.getKeepLocks(), configuration.getSite().getShell(), configuration.getSite().getPart());
    }

    public static boolean isIncludeChangeSets(String message) {
        if (SVNTeamPlugin.instance().getModelChangeSetManager().getSets().length == 0) {
            return false;
        }
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        String consultChangeSetsOption = SVNTeamPreferences.getConsultChangeSetsInCommit(store, "consultChangeSetsInCommit");
        if (consultChangeSetsOption.equals("always")) {
            return true;
        }
        if (consultChangeSetsOption.equals("never")) {
            return false;
        }
        int[] result = new int[1];
        UIMonitorUtility.getDisplay().syncExec(() -> {
            Shell shell = UIMonitorUtility.getShell();
            MessageDialogWithToggle m = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)SVNUIMessages.ConsultChangeSets_toggleDialog_title, (String)message, (String)SVNUIMessages.ConsultChangeSets_toggleDialog_toggleMessage, (boolean)false, (IPreferenceStore)store, (String)SVNTeamPreferences.fullPromptName("consultChangeSetsInCommit"));
            m.getReturnCode();
            nArray[0] = m.getReturnCode();
        });
        switch (result[0]) {
            case 0: 
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }
}

