/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.mapping;

import java.util.Collection;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.svn.core.mapping.SVNChangeSetModelProvider;
import org.eclipse.team.svn.ui.synchronize.AbstractSynchronizeActionGroup;
import org.eclipse.team.svn.ui.synchronize.SynchronizeLabelDecorator;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public abstract class AbstractSVNModelParticipant
extends ModelSynchronizeParticipant {
    protected ISynchronizePageConfiguration configuration;

    public AbstractSVNModelParticipant() {
    }

    public AbstractSVNModelParticipant(SynchronizationContext context) {
        super(context);
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        this.configuration = configuration;
        Collection<AbstractSynchronizeActionGroup> actionGroups = this.getActionGroups();
        for (AbstractSynchronizeActionGroup actionGroup : actionGroups) {
            actionGroup.configureMenuGroups(configuration);
        }
        for (AbstractSynchronizeActionGroup actionGroup : actionGroups) {
            configuration.addActionContribution((SynchronizePageActionGroup)actionGroup);
        }
        configuration.addLabelDecorator(this.createLabelDecorator(configuration));
        configuration.setSupportedModes(this.getSupportedModes());
        configuration.setMode(this.getDefaultMode());
    }

    protected ILabelDecorator createLabelDecorator(ISynchronizePageConfiguration configuration) {
        return new SynchronizeLabelDecorator(configuration);
    }

    protected abstract int getSupportedModes();

    protected abstract int getDefaultMode();

    protected abstract Collection<AbstractSynchronizeActionGroup> getActionGroups();

    public ModelProvider[] getEnabledModelProviders() {
        ModelProvider[] enabledProviders = super.getEnabledModelProviders();
        if (this instanceof IChangeSetProvider) {
            ModelProvider[] modelProviderArray = enabledProviders;
            int n = enabledProviders.length;
            int n2 = 0;
            while (n2 < n) {
                ModelProvider provider = modelProviderArray[n2];
                if (provider.getId().equals("org.eclipse.team.svn.core.svnChangeSetModel")) {
                    return enabledProviders;
                }
                ++n2;
            }
            ModelProvider[] extended = new ModelProvider[enabledProviders.length + 1];
            int i = 0;
            while (i < enabledProviders.length) {
                extended[i] = enabledProviders[i];
                ++i;
            }
            SVNChangeSetModelProvider provider = SVNChangeSetModelProvider.getProvider();
            if (provider == null) {
                return enabledProviders;
            }
            extended[extended.length - 1] = provider;
            return extended;
        }
        return enabledProviders;
    }
}

