/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.history.filter;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.ui.history.filter.ILogEntryFilter;

public class CompositeLogEntryFilter
implements ILogEntryFilter {
    protected HashSet<ILogEntryFilter> filtersSet;

    public CompositeLogEntryFilter() {
        this.filtersSet = new HashSet();
    }

    public CompositeLogEntryFilter(ILogEntryFilter[] filters) {
        this.filtersSet = new HashSet<ILogEntryFilter>(Arrays.asList(filters));
    }

    @Override
    public boolean accept(SVNLogEntry logEntry) {
        for (ILogEntryFilter current : this.filtersSet) {
            if (current.accept(logEntry)) continue;
            return false;
        }
        return true;
    }

    public void addFilter(ILogEntryFilter filter) {
        this.filtersSet.add(filter);
    }

    public void removeFilter(ILogEntryFilter filter) {
        this.filtersSet.remove(filter);
    }
}

