/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local;

import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.IUnresolvedConflictDetector;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SwitchOperation;
import org.eclipse.team.svn.core.operation.local.property.GetPropertiesOperation;
import org.eclipse.team.svn.core.operation.local.property.SetPropertiesOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.AbstractNonRecursiveTeamAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.dialog.OperationErrorDialog;
import org.eclipse.team.svn.ui.operation.NotifyUnresolvedConflictOperation;
import org.eclipse.team.svn.ui.panel.local.SwitchPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class SwitchAction
extends AbstractNonRecursiveTeamAction {
    @Override
    public void runImpl(IAction action) {
        SwitchPanel panel;
        IRepositoryResource remote;
        IResource[] resources = this.getSelectedResources(IStateFilter.SF_EXCLUDE_DELETED);
        if (!OperationErrorDialog.isAcceptableAtOnce(resources, SVNUIMessages.SwitchAction_Error, this.getShell())) {
            return;
        }
        if (resources.length > 1) {
            boolean containFolders = false;
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource current = iResourceArray[n2];
                if (current instanceof IContainer) {
                    containFolders = true;
                    break;
                }
                ++n2;
            }
            remote = SVNRemoteStorage.instance().asRepositoryResource(resources[0]);
            remote = SVNUtility.getTrunkLocation((IRepositoryResource)remote);
            panel = new SwitchPanel(remote, -1L, containFolders);
        } else {
            IResource resource = resources[0];
            remote = SVNRemoteStorage.instance().asRepositoryResource(resource);
            ILocalResource local = SVNRemoteStorage.instance().asLocalResourceAccessible(resource);
            panel = new SwitchPanel(remote, local.getRevision(), resources[0] instanceof IContainer);
        }
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            IRepositoryResource[] destinations = panel.getSelection(resources);
            boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
            SwitchOperation mainOp = new SwitchOperation(resources, destinations, panel.getDepth(), panel.isStickyDepth(), ignoreExternals);
            CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
            HashMap<IResource, String> externalsMap = new HashMap<IResource, String>();
            int i = 0;
            while (i < resources.length) {
                ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resources[i]);
                if ((local.getChangeMask() & 0x80) != 0) {
                    IResource externalsPropNode = null;
                    IResource parent = resources[i];
                    block2: while (externalsPropNode == null && parent.getType() != 4) {
                        GetPropertiesOperation propOp = new GetPropertiesOperation(parent = parent.getParent());
                        if (UIMonitorUtility.doTaskBusyDefault((IActionOperation)propOp).getOperation().getExecutionState() != 0) continue;
                        SVNProperty[] sVNPropertyArray = propOp.getProperties();
                        int n = sVNPropertyArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            SVNProperty prop = sVNPropertyArray[n3];
                            if ("svn:externals".equals(prop.name)) {
                                SVNUtility.SVNExternalPropertyData[] data;
                                String tVal = externalsMap.containsKey(parent) ? (String)externalsMap.get(parent) : prop.value;
                                SVNUtility.SVNExternalPropertyData[] sVNExternalPropertyDataArray = data = SVNUtility.SVNExternalPropertyData.parse((String)tVal);
                                int n4 = data.length;
                                int n5 = 0;
                                while (n5 < n4) {
                                    SVNUtility.SVNExternalPropertyData entry = sVNExternalPropertyDataArray[n5];
                                    IPath localPath = FileUtility.getResourcePath((IResource)parent).append(entry.localPath);
                                    if (localPath.equals((Object)FileUtility.getResourcePath((IResource)resources[i]))) {
                                        entry.url = SVNUtility.encodeURL((String)destinations[i].getUrl());
                                        String propVal = SVNUtility.SVNExternalPropertyData.serialize((SVNUtility.SVNExternalPropertyData[])data);
                                        externalsPropNode = parent;
                                        externalsMap.put(parent, propVal);
                                        continue block2;
                                    }
                                    ++n5;
                                }
                                continue block2;
                            }
                            ++n3;
                        }
                    }
                }
                ++i;
            }
            for (IResource propNode : externalsMap.keySet()) {
                SetPropertiesOperation setOp = new SetPropertiesOperation(new IResource[]{propNode}, new SVNProperty[]{new SVNProperty("svn:externals", (String)externalsMap.get(propNode))}, false);
                op.add((IActionOperation)setOp);
            }
            if (externalsMap.size() > 0) {
                op.add((IActionOperation)new RefreshResourcesOperation(externalsMap.keySet().toArray(new IResource[externalsMap.size()]), 0, RefreshResourcesOperation.REFRESH_CACHE));
            }
            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
            op.add((IActionOperation)saveOp);
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
            op.add((IActionOperation)new RefreshResourcesOperation(resources));
            op.add((IActionOperation)new NotifyUnresolvedConflictOperation((IUnresolvedConflictDetector)mainOp));
            this.runScheduled((IActionOperation)op);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.checkForResourcesPresence(IStateFilter.SF_EXCLUDE_DELETED);
    }

    @Override
    protected boolean needsToSaveDirtyEditors() {
        return true;
    }
}

