/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.action.AbstractRecursiveTeamAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.local.EditTreeConflictsPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class EditTreeConflictsAction
extends AbstractRecursiveTeamAction {
    @Override
    public void runImpl(IAction action) {
        ILocalResource local;
        IResource[] resources = this.getSelectedResources(IStateFilter.SF_TREE_CONFLICTING);
        if (resources.length > 0 && (local = SVNRemoteStorage.instance().asLocalResource(resources[0])).hasTreeConflict()) {
            EditTreeConflictsPanel editConflictsPanel = new EditTreeConflictsPanel(local);
            DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), editConflictsPanel);
            if (dialog.open() == 0 && editConflictsPanel.getOperation() != null) {
                this.runScheduled(editConflictsPanel.getOperation());
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getSelectedResources().length == 1 && this.checkForResourcesPresence(IStateFilter.SF_TREE_CONFLICTING);
    }

    @Override
    protected boolean needsToSaveDirtyEditors() {
        return true;
    }
}

