/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.AttachmentBuilder;
import org.apache.cxf.jaxrs.ext.multipart.InputStreamDataSource;
import org.eclipse.osee.framework.jdk.core.util.Message;

@Provider
public class AttachmentMessageBodyReader
implements MessageBodyReader<Attachment> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == Attachment.class;
    }

    public Attachment readFrom(Class<Attachment> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream inputStream) throws IOException, WebApplicationException {
        if (Objects.isNull(inputStream) || inputStream.available() == 0) {
            throw new NoContentException(new Message().title((CharSequence)"AttachmentMessageBodyReader::readFrom, an empty input stream was recieved.").indentInc().segment((CharSequence)"Type", type).segment((CharSequence)"Generic Type", (Object)genericType).segmentIndexed((CharSequence)"Annotations", (Object[])annotations).segment((CharSequence)"Media Type", (Object)mediaType).segmentMap((CharSequence)"HTTP Headers", httpHeaders).toString());
        }
        AttachmentBuilder attachmentBuilder = new AttachmentBuilder();
        if (Objects.nonNull(httpHeaders)) {
            attachmentBuilder.headers(httpHeaders);
        }
        if (Objects.nonNull(inputStream)) {
            DataHandler dataHandler = new DataHandler((DataSource)new InputStreamDataSource(inputStream, "application/octet-stream"));
            attachmentBuilder.dataHandler(dataHandler);
        }
        Attachment attachment = attachmentBuilder.build();
        return attachment;
    }
}

