/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.eclipse.osee.framework.jdk.core.type.TriFunction;

public class SynchronizedInitializationSupplierUnsynchronizedAccessTriFunction<T, X, Y, R> {
    private volatile T value = null;
    private final VarHandle valueVarHandle;
    private final TriFunction<T, X, Y, R> accessAction;
    private final Supplier<T> initializationAction;
    private final BiFunction<X, Y, R> internalAccessAction;

    public SynchronizedInitializationSupplierUnsynchronizedAccessTriFunction(Class<T> tClass, TriFunction<T, X, Y, R> accessAction, Supplier<T> initializationAction) {
        VarHandle varHandle;
        try {
            varHandle = MethodHandles.privateLookupIn(SynchronizedInitializationSupplierUnsynchronizedAccessTriFunction.class, MethodHandles.lookup()).findVarHandle(SynchronizedInitializationSupplierUnsynchronizedAccessTriFunction.class, "value", tClass);
        }
        catch (Exception exception) {
            varHandle = null;
        }
        this.valueVarHandle = varHandle;
        this.accessAction = Objects.requireNonNull(accessAction);
        this.initializationAction = Objects.requireNonNull(initializationAction);
        this.internalAccessAction = Objects.nonNull(this.valueVarHandle) ? this::accessActionVarHandle : this::accessActionNoVarHandle;
    }

    public R apply(X x, Y y) {
        return this.internalAccessAction.apply(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R accessActionVarHandle(X x, Y y) {
        if (Objects.nonNull(this.valueVarHandle.get(this)) || Objects.nonNull(this.valueVarHandle.getVolatile(this))) {
            return this.accessAction.apply(this.value, x, y);
        }
        SynchronizedInitializationSupplierUnsynchronizedAccessTriFunction synchronizedInitializationSupplierUnsynchronizedAccessTriFunction = this;
        synchronized (synchronizedInitializationSupplierUnsynchronizedAccessTriFunction) {
            if (Objects.isNull(this.valueVarHandle.getVolatile(this))) {
                this.value = this.initializationAction.get();
            }
        }
        return this.accessAction.apply(this.value, x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R accessActionNoVarHandle(X x, Y y) {
        if (Objects.nonNull(this.value)) {
            return this.accessAction.apply(this.value, x, y);
        }
        SynchronizedInitializationSupplierUnsynchronizedAccessTriFunction synchronizedInitializationSupplierUnsynchronizedAccessTriFunction = this;
        synchronized (synchronizedInitializationSupplierUnsynchronizedAccessTriFunction) {
            if (Objects.isNull(this.value)) {
                this.value = this.initializationAction.get();
            }
        }
        return this.accessAction.apply(this.value, x, y);
    }
}

