/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithGammas;
import org.eclipse.osee.accessor.types.AttributePojo;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.mim.types.ConnectionViewData;
import org.eclipse.osee.mim.types.InterfaceConnection;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.TransportType;

public class ConnectionView
extends ArtifactAccessorResultWithGammas {
    private String source = "";
    private String target = "";
    private String label = "";
    private ConnectionViewData data;

    public ConnectionView(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public ConnectionView(InterfaceConnection connection, String source, String target) {
        this(connection.getId(), connection.getGammaId(), (AttributePojo<String>)connection.getName(), connection.getDescription(), connection.getTransportType(), connection.getNodes());
        this.setSource(source);
        this.setTarget(target);
        this.setApplicability(connection.getApplicability());
    }

    public ConnectionView(ArtifactReadable art) {
        this();
        this.setId(art.getId());
        this.setName(AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.Name, (Object)"")));
        this.setData(new ConnectionViewData(art));
        this.setDescription((AttributePojo<String>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.Description, (Object)"")));
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
    }

    public ConnectionView(Long id, GammaId gamma, AttributePojo<String> name, AttributePojo<String> description, TransportType transportType, List<InterfaceNode> nodes) {
        super(id, name);
        this.setLabel((String)name.getValue());
        this.setData(new ConnectionViewData(id, name));
        this.data.setGamma(gamma);
        this.setGamma(gamma);
        this.setDescription(description);
        this.setTransportType(transportType);
        this.setNodes(nodes);
    }

    public ConnectionView(Long id, String name) {
        super(id, AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.Name, (GammaId)GammaId.SENTINEL, (Object)name, (String)""));
    }

    public ConnectionView() {
    }

    @JsonIgnore
    public AttributePojo<String> getDescription() {
        return this.data.getDescription();
    }

    public void setDescription(AttributePojo<String> description) {
        this.data.setDescription(description);
    }

    @JsonIgnore
    public AttributePojo<String> getName() {
        return super.getName();
    }

    public void setName(String name) {
        super.setName(name);
        this.setLabel(name);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ConnectionViewData getData() {
        return this.data;
    }

    public void setData(ConnectionViewData data) {
        this.data = data;
    }

    @JsonIgnore
    public TransportType getTransportType() {
        return this.data.getTransportType();
    }

    @JsonIgnore
    public void setTransportType(TransportType type) {
        this.data.setTransportType(type);
    }

    private void setNodes(List<InterfaceNode> nodes) {
        this.data.setNodes(nodes);
    }

    @JsonIgnore
    public boolean getIsDashed() {
        return this.data.isDashed();
    }

    @JsonIgnore
    public ApplicabilityToken getApplicability() {
        return this.data.getApplicability();
    }

    public void setApplicability(ApplicabilityToken applicabilityToken) {
        this.data.setApplicability(applicabilityToken);
    }
}

