/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.mim.MimPeerReviewApi;
import org.eclipse.osee.mim.types.ApplyResult;
import org.eclipse.osee.mim.types.PeerReviewApplyData;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class MimPeerReviewApiImpl
implements MimPeerReviewApi {
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;

    MimPeerReviewApiImpl(OrcsApi orcsApi, AtsApi atsApi) {
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
    }

    @Override
    public BranchId resetPeerReviewBranch(BranchId prBranchId) {
        Branch prBranch = (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(prBranchId)).getResults().getAtMostOneOrDefault((Object)Branch.SENTINEL);
        List list = ((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andBranch(new BranchId[]{prBranch})).getResults().getList();
        List transactionsToPurge = list.stream().filter(a -> a.getComment().startsWith("Commit Branch")).map(a -> TransactionId.valueOf((Long)a.getId())).collect(Collectors.toList());
        Integer call = 1;
        if (transactionsToPurge.isEmpty()) {
            return prBranchId;
        }
        try {
            call = (Integer)this.orcsApi.getTransactionFactory().purgeTransaction(transactionsToPurge).call();
        }
        catch (Exception exception) {
            throw new OseeCoreException("Error purging transactions", new Object[0]);
        }
        if (call == 0) {
            return BranchId.SENTINEL;
        }
        this.orcsApi.getBranchOps().setBranchState(prBranchId, BranchState.CREATED);
        return prBranchId;
    }

    @Override
    public List<BranchId> getAppliedBranches(BranchId prBranchId) {
        ArrayList<BranchId> appliedBranches = new ArrayList<BranchId>();
        String query = "select wb.branch_id, wb.branch_name from osee_branch b, osee_tx_details txd, osee_branch wb where b.branch_id = ? and b.branch_id = txd.branch_id and txd.transaction_id > b.baseline_transaction_id and txd.commit_art_id > ? and wb.associated_art_id = txd.commit_art_id and wb.branch_state = 1";
        this.orcsApi.getJdbcService().getClient().runQuery(chStmt -> {
            boolean bl = appliedBranches.add(BranchId.valueOf((Long)chStmt.getLong("branch_id")));
        }, query, new Object[]{prBranchId, 0});
        return appliedBranches;
    }

    @Override
    public ApplyResult applyWorkingBranches(BranchId prBranchId, PeerReviewApplyData data) {
        ApplyResult applyResult = new ApplyResult(true, "Apply log...\n");
        Branch prBranch = (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(prBranchId)).getResults().getAtMostOneOrDefault((Object)Branch.SENTINEL);
        List<BranchId> currentAppliedBranches = this.getAppliedBranches(prBranchId);
        if (prBranch.isInvalid()) {
            return applyResult;
        }
        if (!currentAppliedBranches.isEmpty() && !data.getRemoveBranches().isEmpty()) {
            currentAppliedBranches.removeIf(a -> data.getRemoveBranches().contains(a));
        }
        if (!data.getAddBranches().isEmpty()) {
            currentAppliedBranches.addAll(data.getAddBranches());
        }
        if (prBranch.getBranchState().isModified()) {
            prBranchId = this.resetPeerReviewBranch(prBranchId);
        }
        List branchesToApply = currentAppliedBranches.stream().distinct().collect(Collectors.toList());
        for (BranchId wBranch : branchesToApply) {
            IAtsTeamWorkflow wbWf = this.atsApi.getQueryService().getTeamWf(this.atsApi.getBranchService().getAssociatedArtifactId(wBranch));
            TransactionToken call = TransactionToken.SENTINEL;
            try {
                call = (TransactionToken)this.orcsApi.getBranchOps().commitBranch((ArtifactId)this.orcsApi.userService().getUser(), wBranch, prBranchId).call();
            }
            catch (Exception ex) {
                throw new OseeCoreException("Error applying branch:" + wBranch.getIdString() + " to branch: " + prBranch.getIdString() + " Exception: " + ex.getMessage(), new Object[0]);
            }
            if (call.isInvalid()) {
                applyResult.setSuccess(false);
                applyResult.setStatusText(String.valueOf(applyResult.getStatusText()) + "Error applying: " + wbWf.getName() + "\n");
                break;
            }
            applyResult.setStatusText(String.valueOf(applyResult.getStatusText()) + "Applied: " + wbWf.getName() + "\n");
        }
        return applyResult;
    }
}

