/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.InterfaceNodeEndpoint;
import org.eclipse.osee.mim.InterfaceNodeViewApi;
import org.eclipse.osee.mim.types.InterfaceNode;

public class InterfaceNodeEndpointImpl
implements InterfaceNodeEndpoint {
    private final BranchId branch;
    private final InterfaceNodeViewApi interfaceNodeApi;

    public InterfaceNodeEndpointImpl(BranchId branch, InterfaceNodeViewApi interfaceNodeApi) {
        this.branch = branch;
        this.interfaceNodeApi = interfaceNodeApi;
    }

    @Override
    public Collection<InterfaceNode> getAllNodes(long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        return this.interfaceNodeApi.getAll(this.branch, pageNum, pageSize, orderByAttributeType);
    }

    @Override
    public InterfaceNode getNode(ArtifactId nodeId) {
        try {
            return (InterfaceNode)((Object)this.interfaceNodeApi.getAccessor().get(this.branch, nodeId));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public Collection<InterfaceNode> getNodes(ArtifactId connectionId) {
        try {
            LinkedList<InterfaceNode> nodes = new LinkedList<InterfaceNode>();
            nodes.addAll(this.interfaceNodeApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceConnectionNode_Connection, connectionId));
            return nodes;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public Collection<InterfaceNode> getNodesByName(String name, ArtifactId connectionId, long pageNum, long pageSize) {
        if (connectionId != null && connectionId.isValid()) {
            return this.interfaceNodeApi.getNodesForConnectionByName(this.branch, connectionId, name, pageNum, pageSize);
        }
        return this.interfaceNodeApi.getNodesByName(this.branch, name, pageNum, pageSize);
    }

    @Override
    public int getNodesByNameCount(String name) {
        return this.interfaceNodeApi.getNodesByNameCount(this.branch, name);
    }
}

