/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.mim.InterfaceConnectionViewApi;
import org.eclipse.osee.mim.InterfaceGraphEndpoint;
import org.eclipse.osee.mim.InterfaceNodeViewApi;
import org.eclipse.osee.mim.types.ClusterView;
import org.eclipse.osee.mim.types.ConnectionView;
import org.eclipse.osee.mim.types.GraphView;
import org.eclipse.osee.mim.types.InterfaceConnection;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.NodeView;

public class InterfaceGraphEndpointImpl
implements InterfaceGraphEndpoint {
    private final BranchId branch;
    private final InterfaceNodeViewApi interfaceNodeApi;
    private final InterfaceConnectionViewApi interfaceConnectionApi;

    public InterfaceGraphEndpointImpl(BranchId branch, InterfaceNodeViewApi interfaceNodeApi, InterfaceConnectionViewApi interfaceConnectionViewApi) {
        this.branch = branch;
        this.interfaceNodeApi = interfaceNodeApi;
        this.interfaceConnectionApi = interfaceConnectionViewApi;
    }

    @Override
    public GraphView getAllNodesAndEdges(ArtifactId viewId) {
        try {
            GraphView graph = new GraphView();
            graph.setEdges(new LinkedList<ConnectionView>());
            graph.setNodes(new LinkedList<NodeView>());
            graph.setClusters(new LinkedList<ClusterView>());
            Collection nodes = this.interfaceNodeApi.getAccessor().getAll(this.branch, viewId);
            Collection<InterfaceConnection> edges = this.interfaceConnectionApi.getAll(this.branch, viewId);
            for (InterfaceNode node : nodes) {
                graph.addNode(new NodeView(node));
                if (((String)node.getInterfaceNodeGroupId().getValue()).isEmpty()) continue;
                String clusterId = (String)node.getInterfaceNodeGroupId().getValue();
                ClusterView cluster = graph.getClusters().stream().filter(c -> c.getId().equals(clusterId)).findFirst().orElse(null);
                if (cluster == null) {
                    cluster = new ClusterView(clusterId);
                    graph.getClusters().add(cluster);
                }
                cluster.getChildNodeIds().add(node.getIdString());
            }
            graph.getClusters().removeIf(c -> c.getChildNodeIds().size() < 2);
            for (InterfaceConnection connection : edges) {
                if (connection.getTransportType().isDirectConnection() && connection.getNodes().size() == 2) {
                    graph.addEdges(new ConnectionView(connection, connection.getNodes().get(0).getIdString(), connection.getNodes().get(1).getIdString()));
                    continue;
                }
                if (connection.getTransportType().isDirectConnection()) continue;
                ClusterView controllerCluster = new ClusterView(connection.getName() + "_controller");
                ClusterView nodesCluster = new ClusterView(connection.getName() + "_nodes");
                InterfaceNode controllerNode = new InterfaceNode();
                controllerNode.setName(connection.getName() + " Controller");
                controllerNode.setInterfaceNodeBackgroundColor("#FFFFFF");
                NodeView controllerNodeView = new NodeView(controllerNode);
                controllerNodeView.setId((String)controllerNode.getName().getValue());
                graph.addNode(controllerNodeView);
                controllerCluster.getChildNodeIds().add(controllerNodeView.getId());
                InterfaceNode nodesClusterNode = new InterfaceNode();
                nodesClusterNode.setName(connection.getName() + " Nodes");
                nodesClusterNode.setInterfaceNodeBackgroundColor("#FFFFFF");
                NodeView nodesClusterNodeView = new NodeView(nodesClusterNode);
                nodesClusterNodeView.setId((String)nodesClusterNode.getName().getValue());
                graph.addNode(nodesClusterNodeView);
                nodesCluster.getChildNodeIds().add(nodesClusterNodeView.getId());
                for (InterfaceNode node : connection.getNodes()) {
                    nodesCluster.getChildNodeIds().add(node.getIdString());
                }
                graph.addEdges(new ConnectionView(connection, controllerNodeView.getId(), nodesClusterNodeView.getId()));
                graph.getClusters().add(controllerCluster);
                graph.getClusters().add(nodesCluster);
            }
            return graph;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }
}

