/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.notify.AtsNotificationCollector;
import org.eclipse.osee.ats.api.notify.AtsNotificationEvent;
import org.eclipse.osee.ats.api.notify.AtsNotificationEventFactory;
import org.eclipse.osee.ats.api.notify.AtsNotifyType;
import org.eclipse.osee.ats.api.notify.AtsWorkItemNotificationEvent;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsChangeSetListener;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.ats.core.util.AtsRelationChange;
import org.eclipse.osee.framework.core.data.ArtifactAnnotation;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public abstract class AbstractAtsChangeSet
implements IAtsChangeSet {
    protected String comment;
    protected final Set<AtsRelationChange> relations = new CopyOnWriteArraySet<AtsRelationChange>();
    protected final Set<IAtsObject> atsObjects = new CopyOnWriteArraySet<IAtsObject>();
    protected final Set<ArtifactId> artifacts = new CopyOnWriteArraySet<ArtifactId>();
    protected final Set<IAtsObject> deleteAtsObjects = new CopyOnWriteArraySet<IAtsObject>();
    protected final Set<ArtifactId> deleteArtifacts = new CopyOnWriteArraySet<ArtifactId>();
    protected final Set<IAtsChangeSetListener> listeners = new CopyOnWriteArraySet<IAtsChangeSetListener>();
    protected final AtsUser asUser;
    protected final AtsNotificationCollector notifications = new AtsNotificationCollector();
    protected final List<IAtsWorkItem> workItemsCreated = new ArrayList<IAtsWorkItem>();
    protected boolean execptionIfEmpty = true;
    protected BranchToken branch;
    protected Set<ArtifactId> ids = new HashSet<ArtifactId>();
    protected Map<String, String> seqNameToStartNum = new HashMap<String, String>();
    protected boolean executed = false;
    protected HashCollection<IAtsWorkItem, AtsUser> initialAssignees = new HashCollection();
    protected AtsApi atsApi;
    protected TransactionToken transactionTok = TransactionToken.SENTINEL;

    public AbstractAtsChangeSet(String comment, BranchToken branch, AtsUser asUser) {
        this.comment = comment;
        this.branch = branch;
        this.asUser = asUser;
        this.atsApi = AtsApiService.get();
        Conditions.checkNotNullOrEmpty((String)comment, (String)"comment");
        Conditions.checkNotNull((Object)branch, (String)"branch");
        Conditions.checkNotNull((Object)asUser, (String)"user");
        Conditions.assertTrue((boolean)branch.isValid(), (String)"%s is not a valid branch", (Object[])new Object[]{branch});
    }

    public Set<ArtifactId> getIds() {
        return this.ids;
    }

    protected void checkExecuted() {
        if (this.executed) {
            throw new OseeStateException("Change Set already used.", new Object[0]);
        }
    }

    public void add(Object obj) {
        this.checkExecuted();
        Conditions.checkNotNull((Object)obj, (String)"object");
        if (obj instanceof Collection) {
            for (Object object : (Collection)obj) {
                this.add(object);
            }
        } else if (obj instanceof IAtsObject) {
            IAtsObject atsObj = (IAtsObject)obj;
            if (atsObj.getStoreObject() != null && !atsObj.getStoreObject().getBranch().equals(this.branch)) {
                throw new OseeArgumentException("Can't add %s from branch %s to conflicting branch %s in same transaction", new Object[]{atsObj.toStringWithId(), atsObj.getStoreObject().getBranchIdString(), this.branch.getIdString()});
            }
            this.atsObjects.add((IAtsObject)obj);
            this.ids.add(((IAtsObject)obj).getArtifactId());
        } else if (obj instanceof ArtifactToken) {
            ArtifactToken artTok = (ArtifactToken)obj;
            if (!artTok.getBranch().equals(this.branch)) {
                throw new OseeArgumentException("Can't add %s from branch %s to conflicting branch %s in same transaction", new Object[]{artTok.toStringWithId(), artTok.getBranchIdString(), this.branch.getIdString()});
            }
            this.artifacts.add((ArtifactId)((ArtifactToken)obj));
            this.ids.add((ArtifactId)((ArtifactToken)obj));
        } else if (obj instanceof ArtifactId) {
            this.artifacts.add((ArtifactId)obj);
            this.ids.add((ArtifactId)obj);
        } else if (obj instanceof AtsRelationChange) {
            AtsRelationChange relation = (AtsRelationChange)obj;
            this.relations.add(relation);
            for (Object ob : relation.getObjects()) {
                this.add(ob);
            }
        } else {
            throw new OseeArgumentException("Object not supported: " + obj, new Object[0]);
        }
    }

    public void addAll(Object ... objects) {
        this.checkExecuted();
        Conditions.checkNotNull((Object)objects, (String)"objects");
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.add(obj);
            ++n2;
        }
    }

    public void setComment(String comment) {
        this.checkExecuted();
        this.comment = comment;
    }

    public boolean isEmpty() {
        return this.artifacts.isEmpty() && this.deleteArtifacts.isEmpty() && this.atsObjects.isEmpty() && this.deleteAtsObjects.isEmpty() && this.relations.isEmpty();
    }

    public void addExecuteListener(IAtsChangeSetListener listener) {
        Conditions.checkNotNull((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    public void addToDelete(Object obj) {
        this.checkExecuted();
        Conditions.checkNotNull((Object)obj, (String)"object");
        if (obj instanceof Collection) {
            for (Object object : (Collection)obj) {
                this.add(object);
            }
        } else if (obj instanceof IAtsObject) {
            this.deleteAtsObjects.add((IAtsObject)obj);
        } else if (obj instanceof ArtifactId) {
            this.deleteArtifacts.add((ArtifactId)obj);
        } else {
            throw new OseeArgumentException("Object not supported: " + obj, new Object[0]);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public AtsNotificationCollector getNotifications() {
        return this.notifications;
    }

    public ArtifactToken createArtifact(ArtifactToken token) {
        this.checkExecuted();
        ArtifactTypeToken typeToken = token.getArtifactType();
        if (typeToken.isInvalid()) {
            throw new OseeArgumentException("Artifact Type Token %s is invalid for artifact creation", new Object[]{typeToken.toStringWithId()});
        }
        return this.createArtifact(token.getArtifactType(), token.getName(), token.getId());
    }

    public void deleteArtifact(IAtsWorkItem task) {
        this.checkExecuted();
        this.deleteArtifact((ArtifactId)task.getStoreObject());
    }

    public void addWorkflowCreated(IAtsTeamWorkflow teamWf) {
        this.checkExecuted();
        this.workItemsCreated.add((IAtsWorkItem)teamWf);
    }

    public AtsUser getAsUser() {
        return this.asUser;
    }

    public void unrelate(IAtsObject atsObject, RelationTypeSide relationSide, IAtsObject atsObjec2) {
        this.unrelate((ArtifactId)atsObject.getStoreObject(), relationSide, (ArtifactId)atsObjec2.getStoreObject());
    }

    public void unrelate(ArtifactId artifact, RelationTypeSide relationSide, IAtsObject atsObject) {
        this.unrelate(artifact, relationSide, (ArtifactId)atsObject.getStoreObject());
    }

    public void unrelate(IAtsObject atsObject, RelationTypeSide relationSide, ArtifactId artifact) {
        this.unrelate((ArtifactId)atsObject.getStoreObject(), relationSide, artifact);
    }

    public void setSoleAttributeFromString(IAtsObject atsObject, AttributeTypeGeneric<?> attributeType, String value) {
        this.setSoleAttributeFromString((ArtifactId)atsObject.getStoreObject(), attributeType, value);
    }

    public void setRelation(Object object1, RelationTypeSide relationSide, Object object2) {
        this.setRelations(object1, relationSide, Collections.singleton(object2));
    }

    public void addChild(ArtifactId parent, ArtifactId child) {
        this.checkExecuted();
        this.relate(parent, CoreRelationTypes.DefaultHierarchical_Child, child);
    }

    public void setName(ArtifactToken artifact, String name) {
        this.checkExecuted();
        this.setSoleAttributeValue((ArtifactId)artifact, (AttributeTypeToken)CoreAttributeTypes.Name, name);
    }

    public void setName(IAtsObject atsObject, String name) {
        this.checkExecuted();
        this.setSoleAttributeValue(atsObject, (AttributeTypeToken)CoreAttributeTypes.Name, name);
    }

    public void addWorkItemNotificationEvent(AtsWorkItemNotificationEvent workItemNotificationEvent) {
        this.checkExecuted();
        this.notifications.getWorkItemNotificationEvents().add(workItemNotificationEvent);
    }

    public void addNotificationEvent(AtsNotificationEvent notifyEvent) {
        this.checkExecuted();
        this.notifications.getNotificationEvents().add(notifyEvent);
    }

    public List<IAtsWorkItem> getWorkItemsCreated() {
        return this.workItemsCreated;
    }

    public void addChild(IAtsObject parent, IAtsObject child) {
        this.checkExecuted();
        this.add(new AtsRelationChange(parent, CoreRelationTypes.DefaultHierarchical_Child, Collections.singleton(child), AtsRelationChange.RelationOperation.Add));
    }

    public ArtifactId getStoredArtifact(Id id) {
        for (ArtifactId art : this.artifacts) {
            if (!art.getId().equals(id.getId())) continue;
            return art;
        }
        return null;
    }

    public IAtsObject getStoredAtsObject(Id id) {
        for (IAtsObject obj : this.atsObjects) {
            if (!obj.equals(id)) continue;
            return obj;
        }
        return null;
    }

    public ArtifactToken createArtifact(ArtifactToken parent, ArtifactToken artifact) {
        this.checkExecuted();
        ArtifactToken art = this.createArtifact(artifact);
        if (parent != null) {
            this.addChild((ArtifactId)parent, (ArtifactId)art);
        }
        return art;
    }

    public BranchId getBranch() {
        return this.branch;
    }

    public void addTag(IAtsObject atsObject, String tag) {
        this.checkExecuted();
        if (atsObject.getTags() != null && !atsObject.getTags().contains(tag)) {
            this.addAttribute(atsObject, (AttributeTypeToken)CoreAttributeTypes.StaticId, tag);
        }
    }

    public void addAtsIdSequence(String seqName, String seqStart) {
        this.checkExecuted();
        this.seqNameToStartNum.put(seqName, seqStart);
    }

    public void addAssignee(IAtsWorkItem workItem, AtsUser assignee) {
        this.assigneesChanging(workItem);
        List assignees = workItem.getAssignees();
        assignees.add(assignee);
        this.setAssignees(workItem, assignees);
    }

    public void setAssignees(IAtsWorkItem workItem, Collection<AtsUser> newAssignees) {
        this.assigneesChanging(workItem);
        if (newAssignees == null || newAssignees.isEmpty()) {
            newAssignees = new HashSet<AtsUser>();
            newAssignees.add(AtsCoreUsers.UNASSIGNED_USER);
        }
        for (AtsUser assignee : newAssignees) {
            if (!AtsCoreUsers.isSystemUser((AtsUser)assignee)) continue;
            throw new OseeArgumentException("Can not assign workflow to System User", new Object[0]);
        }
        if (newAssignees.size() > 1 && newAssignees.contains(AtsCoreUsers.UNASSIGNED_USER)) {
            newAssignees.remove(AtsCoreUsers.UNASSIGNED_USER);
        }
        ArrayList<String> newAssigneeIds = new ArrayList<String>();
        for (AtsUser user : newAssignees) {
            newAssigneeIds.add(user.getIdString());
        }
        this.setAttributeValues((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateAssignee, newAssigneeIds);
    }

    public void setAssignee(IAtsWorkItem workItem, IStateToken state, AtsUser assignee) {
        this.assigneesChanging(workItem);
        this.setAttributeValues((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateAssignee, Arrays.asList(assignee.getIdString()));
    }

    public void removeAssignee(IAtsWorkItem workItem, AtsUser assignee) {
        this.assigneesChanging(workItem);
        List assignees = workItem.getAssignees();
        assignees.remove(assignee);
        this.setAssignees(workItem, assignees);
    }

    public void clearAssignees(IAtsWorkItem workItem) {
        this.assigneesChanging(workItem);
        this.deleteAttributes((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateAssignee);
    }

    public void addAssignees(IAtsWorkItem workItem, Collection<AtsUser> assignees) {
        this.assigneesChanging(workItem);
        HashSet<AtsUser> newAssignees = new HashSet<AtsUser>();
        newAssignees.addAll(workItem.getAssignees());
        newAssignees.addAll(assignees);
        this.setAssignees(workItem, newAssignees);
    }

    public void setAssignee(IAtsWorkItem workItem, AtsUser assignee) {
        this.assigneesChanging(workItem);
        this.setAssignees(workItem, Arrays.asList(assignee));
    }

    private void assigneesChanging(IAtsWorkItem workItem) {
        if (this.initialAssignees.getValues((Object)workItem) == null) {
            this.initialAssignees.put((Object)workItem, (Collection)workItem.getAssignees());
        }
    }

    protected void addAssigneeNotificationEvents() {
        for (Map.Entry entry : this.initialAssignees.entrySet()) {
            IAtsWorkItem workItem = (IAtsWorkItem)entry.getKey();
            List initialAssignees = (List)entry.getValue();
            List assigneesAdded = org.eclipse.osee.framework.jdk.core.util.Collections.setComplement((Collection)workItem.getAssignees(), (Collection)initialAssignees);
            if (assigneesAdded.isEmpty()) continue;
            AtsWorkItemNotificationEvent notificationEvent = AtsNotificationEventFactory.getWorkItemNotificationEvent((AtsUser)this.asUser, (IAtsWorkItem)workItem, (List)assigneesAdded, (AtsNotifyType[])new AtsNotifyType[]{AtsNotifyType.Assigned});
            this.addWorkItemNotificationEvent(notificationEvent);
        }
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public void setExecuted(boolean executed) {
        this.executed = executed;
    }

    public void setCreatedBy(IAtsWorkItem workItem, AtsUser user, boolean logChange, Date date) {
        if (logChange) {
            this.logCreatedByChange(workItem, user);
        }
        this.atsApi.getAttributeResolver().setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.CreatedBy, (Object)user.getUserId());
        if (date != null) {
            this.atsApi.getAttributeResolver().setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.CreatedDate, (Object)date);
        }
    }

    private void logCreatedByChange(IAtsWorkItem workItem, AtsUser user) {
        if (this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedBy, null) == null) {
            workItem.getLog().addLog(LogType.Originated, "", "", new Date(), user.getUserId());
        } else {
            workItem.getLog().addLog(LogType.Originated, "", "Changed by " + this.atsApi.getUserService().getCurrentUser().getName(), new Date(), user.getUserId());
        }
    }

    public void initalizeWorkflow(IAtsWorkItem workItem, IStateToken startState, Collection<AtsUser> assignees) {
        this.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, startState.getStateType().name());
        this.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateName, startState.getName());
        this.setAssignees(workItem, assignees);
    }

    public void updateForTransition(IAtsWorkItem workItem, IStateToken toState, Collection<AtsUser> toStateAssigees) {
        this.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateName, toState.getName());
        if (toState.isCompletedOrCancelled()) {
            this.clearAssignees(workItem);
            toStateAssigees.clear();
        } else {
            this.setAssignees(workItem, toStateAssigees);
        }
        this.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, toState.getStateType().name());
    }

    public TransactionToken execute() {
        try {
            this.executePreCheck();
            this.executeAtsObjects();
            this.internalExecuteTransaction();
            if (this.transactionTok.isValid()) {
                this.executeNotifyListeners();
                this.executeSendNotifications();
                this.executeClearCaches();
                this.executeUpdateAnySequences();
            }
            this.executed = true;
        }
        catch (Exception ex) {
            this.executeHandleException(ex);
        }
        return this.transactionTok;
    }

    protected void executeHandleException(Exception ex) {
        throw OseeCoreException.wrap((Throwable)ex);
    }

    protected abstract void internalExecuteTransaction();

    protected void executePreCheck() {
        this.checkExecuted();
        Conditions.checkNotNull((Object)this.comment, (String)"comment");
        if (this.isEmpty() && this.execptionIfEmpty) {
            throw new OseeArgumentException("objects/deleteObjects cannot be empty", new Object[0]);
        }
    }

    protected void executeAtsObjects() {
        for (IAtsObject atsObject : new ArrayList<IAtsObject>(this.atsObjects)) {
            IAtsWorkItem workItem;
            if (!(atsObject instanceof IAtsWorkItem) || !(workItem = (IAtsWorkItem)atsObject).getLog().isDirty()) continue;
            this.atsApi.getLogFactory().writeToStore(workItem, this.atsApi.getAttributeResolver(), (IAtsChangeSet)this);
        }
    }

    protected void executeNotifyListeners() {
        for (IAtsChangeSetListener listener : this.listeners) {
            listener.changesStored((IAtsChangeSet)this);
        }
    }

    protected void executeSendNotifications() {
        this.addAssigneeNotificationEvents();
        this.atsApi.getNotificationService().sendNotifications(this.notifications);
    }

    protected void executeClearCaches() {
        for (IAtsObject atsObject : new ArrayList<IAtsObject>(this.atsObjects)) {
            if (!(atsObject instanceof IAtsWorkItem)) continue;
            this.atsApi.getWorkDefinitionService().internalClearWorkDefinition((IAtsWorkItem)atsObject);
            this.atsApi.getStoreService().clearCaches((IAtsWorkItem)atsObject);
        }
    }

    public TransactionToken executeIfNeeded() {
        this.execptionIfEmpty = false;
        TransactionToken tx = this.execute();
        this.executed = true;
        return tx;
    }

    public void executeUpdateAnySequences() {
        for (Map.Entry<String, String> entry : this.seqNameToStartNum.entrySet()) {
            String query = String.format("INSERT INTO osee_sequence (last_sequence, sequence_name) VALUES (%s, '%s')", entry.getValue(), entry.getKey());
            this.atsApi.getQueryService().runUpdate(query, new Object[0]);
        }
    }

    public void addAttributes(ArtifactToken art, AttributeTypeString attrType, String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.addAttribute((ArtifactId)art, (AttributeTypeToken)attrType, name);
            ++n2;
        }
    }

    public void addAnnotation(ArtifactToken art, ArtifactAnnotation annotation) {
        this.addAttribute((ArtifactId)art, (AttributeTypeToken)CoreAttributeTypes.Annotation, annotation.toXml());
    }
}

