/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.JaxAttribute;
import org.eclipse.osee.ats.api.task.JaxRelation;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskSet;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsChangeSetListener;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionToken;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class CreateTasksOperation {
    private final NewTaskSet newTaskSet;
    private final AtsApi atsApi;
    private final List<JaxAtsTask> tasks = new ArrayList<JaxAtsTask>();
    private AtsUser asUser;
    private XResultData results;
    private Date createdByDate;
    private final Map<Long, IAtsTeamWorkflow> idToTeamWf = new HashMap<Long, IAtsTeamWorkflow>();
    private WorkDefinition taskWorkDef;
    private final IAtsChangeSetListener changeSetListener;

    public CreateTasksOperation(NewTaskSet newTaskSet, AtsApi atsApi) {
        this(newTaskSet, null, atsApi);
    }

    public CreateTasksOperation(NewTaskSet newTaskSet, IAtsChangeSetListener changeSetListener, AtsApi atsApi) {
        this.newTaskSet = newTaskSet;
        this.changeSetListener = changeSetListener;
        this.atsApi = atsApi;
    }

    public NewTaskSet validate() {
        this.results = this.newTaskSet.getResults();
        String asUserId = this.newTaskSet.getAsUserId();
        if (asUserId == null) {
            this.results.error("As User Id id not specified");
            return this.newTaskSet;
        }
        this.asUser = this.atsApi.getUserService().getUserByUserId(asUserId);
        if (this.asUser == null) {
            this.results.errorf("As User Id id [%s] does not exist\n", new Object[]{asUserId});
            return this.newTaskSet;
        }
        if (!Strings.isValid((String)this.newTaskSet.getCommitComment())) {
            this.results.errorf("Inavlidate Commit Comment [%s]\n", new Object[]{this.newTaskSet.getCommitComment()});
            return this.newTaskSet;
        }
        for (NewTaskData newTaskData : this.newTaskSet.getNewTaskDatas()) {
            Long teamWfId = newTaskData.getTeamWfId();
            if (teamWfId == null) {
                this.results.error("Team Workflow id not specified");
                continue;
            }
            IAtsTeamWorkflow teamWf = this.getTeamWorkflow(teamWfId);
            if (teamWf == null) {
                this.results.errorf("Team Workflow id %s does not exist\n", new Object[]{teamWfId});
                continue;
            }
            this.taskWorkDef = null;
            AtsWorkDefinitionToken taskWorkDefTok = newTaskData.getTaskWorkDef();
            if (taskWorkDefTok.isValid()) {
                this.taskWorkDef = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)taskWorkDefTok);
                if (this.taskWorkDef == null) {
                    this.results.errorf("Task Work Def Token %s is not defined\n", new Object[]{newTaskData.getTaskWorkDef()});
                    continue;
                }
            }
            for (JaxAtsTask jTask : newTaskData.getTasks()) {
                List assigneeUserIds;
                String relatedToState;
                AtsUser createdBy;
                ArtifactToken taskArt;
                Long taskId = jTask.getId();
                if (taskId != null && taskId > 0L && (taskArt = this.atsApi.getQueryService().getArtifact(taskId)) != null) {
                    this.results.errorf("Task with id %d already exists for %s\n", new Object[]{taskId, jTask});
                }
                if (!Strings.isValid((String)jTask.getName())) {
                    this.results.errorf("Task name [%s] is invalid for %s\n", new Object[]{jTask.getName(), jTask});
                }
                if ((createdBy = this.atsApi.getUserService().getUserByUserId(jTask.getCreatedByUserId())) == null) {
                    this.results.errorf("Task Created By user id %d does not exist in %s\n", new Object[]{createdBy, jTask});
                }
                this.createdByDate = jTask.getCreatedDate();
                if (this.createdByDate == null) {
                    this.results.errorf("Task Created By Date %s does not exist in %s\n", new Object[]{this.createdByDate, jTask});
                }
                if (Strings.isValid((String)(relatedToState = jTask.getRelatedToState())) && teamWf.getWorkDefinition().getStateByName(relatedToState) == null) {
                    this.results.errorf("Task Related To State %s invalid for Team Workflow %d\n", new Object[]{relatedToState, teamWfId});
                }
                if (!(assigneeUserIds = jTask.getAssigneeUserIds()).isEmpty()) {
                    Collection assignees = this.atsApi.getUserService().getUsersByUserIds((Collection)assigneeUserIds);
                    if (assigneeUserIds.size() != assignees.size()) {
                        this.results.errorf("Task Assignees [%s] not all valid in %s\n", new Object[]{String.valueOf(assigneeUserIds), jTask});
                    }
                }
                List assigneeAccountIds = jTask.getAssigneeAccountIds();
                if (!assigneeUserIds.isEmpty()) {
                    for (ArtifactId assignArt : assigneeAccountIds) {
                        AtsUser assignee = this.atsApi.getUserService().getUserById(assignArt);
                        if (assignee != null) continue;
                        this.results.errorf("Task Assignee [%s] valid in %s\n", new Object[]{String.valueOf(assignArt), jTask});
                    }
                }
                if (this.taskWorkDef == null && Strings.isValid((String)jTask.getWorkDef())) {
                    try {
                        this.taskWorkDef = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)ArtifactId.valueOf((String)jTask.getWorkDef()));
                        if (this.taskWorkDef == null) {
                            this.results.errorf("Error finding Task Work Def [%s].\n", new Object[]{jTask.getWorkDef()});
                        }
                    }
                    catch (Exception ex) {
                        this.results.errorf("Exception finding Task Work Def [%s].  Exception: %s\n", new Object[]{jTask.getWorkDef(), ex.getMessage()});
                    }
                }
                if (this.taskWorkDef == null) {
                    this.taskWorkDef = this.atsApi.getWorkDefinitionService().computedWorkDefinitionForTaskNotYetCreated(teamWf);
                }
                Conditions.assertNotNull((Object)this.taskWorkDef, (String)"Work Definition can not be null for [%s]", (Object[])new Object[]{jTask.getWorkDef()});
                for (JaxAttribute attribute : jTask.getAttributes()) {
                    AttributeTypeToken attrType = attribute.getAttrType();
                    if (attrType != null && !attrType.isInvalid()) continue;
                    this.results.errorf("Attribute Type [%s] not valid for Task creation in %s\n", new Object[]{attrType, jTask});
                }
                for (JaxRelation relation : jTask.getRelations()) {
                    RelationTypeToken relationType = this.getRelationType(this.atsApi, relation.getRelationTypeName());
                    if (relationType == null) {
                        this.results.errorf("Relation Type [%s] not valid for Task creation in %s\n", new Object[]{relation.getRelationTypeName(), jTask});
                    }
                    if (relation.getRelatedIds().isEmpty()) {
                        this.results.errorf("Relation [%s] Ids must be suplied Task creation in %s\n", new Object[]{relation.getRelationTypeName(), jTask});
                    }
                    ArrayList<Long> foundWorkItemIds = new ArrayList<Long>();
                    for (ArtifactId foundId : this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andIds(relation.getRelatedIds().toArray(new Long[relation.getRelatedIds().size()])).getItemIds()) {
                        foundWorkItemIds.add(foundId.getId());
                    }
                    if (foundWorkItemIds.size() == relation.getRelatedIds().size()) continue;
                    ArrayList notFoundIds = new ArrayList();
                    notFoundIds.addAll(relation.getRelatedIds());
                    notFoundIds.removeAll(foundWorkItemIds);
                    if (notFoundIds.isEmpty()) continue;
                    this.results.errorf("Relation [%s] Work Item Ids [%s] has unfound Work Item(s) in db for task %s\n", new Object[]{relation.getRelationTypeName(), notFoundIds, jTask});
                }
            }
        }
        return this.newTaskSet;
    }

    private RelationTypeToken getRelationType(AtsApi atsApi, String relationTypeName) {
        return atsApi.tokenService().getRelationType(relationTypeName);
    }

    private IAtsTeamWorkflow getTeamWorkflow(Long teamWfId) {
        ArtifactToken art;
        IAtsTeamWorkflow teamWf = this.idToTeamWf.get(teamWfId);
        if (teamWf == null && (art = this.atsApi.getQueryService().getArtifact(teamWfId)) != null && (teamWf = this.atsApi.getWorkItemService().getTeamWf(art)) != null) {
            this.idToTeamWf.put((long)teamWfId, teamWf);
        }
        return teamWf;
    }

    public List<JaxAtsTask> getTasks() {
        return this.tasks;
    }

    public NewTaskSet run() {
        NewTaskSet taskSet = this.validate();
        if (taskSet.getResults().isErrors()) {
            return this.newTaskSet;
        }
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet(this.newTaskSet.getCommitComment(), this.asUser);
        this.run(changes);
        if (this.changeSetListener != null) {
            this.changeSetListener.changesStored(changes);
        }
        if (this.newTaskSet.getResults().isErrors()) {
            return this.newTaskSet;
        }
        TransactionToken trans = changes.executeIfNeeded();
        if (trans != null && trans.isValid()) {
            this.newTaskSet.setTransaction(trans);
            for (NewTaskData newTaskData : this.newTaskSet.getNewTaskDatas()) {
                for (JaxAtsTask jaxTask : newTaskData.getTasks()) {
                    JaxAtsTask newJaxTask = CreateTasksOperation.createNewJaxTask(jaxTask.getId(), this.atsApi);
                    if (newJaxTask == null) {
                        taskSet.getResults().errorf("Unable to create return New Task for id %s\n" + jaxTask.getIdString(), new Object[0]);
                    }
                    this.tasks.add(newJaxTask);
                }
            }
        }
        return this.newTaskSet;
    }

    public void run(IAtsChangeSet changes) {
        this.createTasks(changes);
        if (changes.isEmpty()) {
            this.results.log(String.valueOf(this.getClass().getSimpleName()) + " Error - No Tasks to Create");
        }
    }

    private void createTasks(IAtsChangeSet changes) {
        for (NewTaskData newTaskData : this.newTaskSet.getNewTaskDatas()) {
            for (JaxAtsTask jTask : newTaskData.getTasks()) {
                Double hoursSpent;
                IAtsTeamWorkflow teamWf = this.idToTeamWf.get(newTaskData.getTeamWfId());
                Conditions.assertNotNull((Object)this.taskWorkDef, (String)"Work Definition can not be null for [%s]", (Object[])new Object[]{newTaskData});
                ArtifactTypeToken artType = AtsArtifactTypes.Task;
                if (this.taskWorkDef.getArtType() != null && this.taskWorkDef.getArtType().isValid()) {
                    artType = this.taskWorkDef.getArtType();
                }
                ArtifactToken taskArt = null;
                taskArt = jTask.isValid() ? changes.createArtifact(artType, jTask.getName(), jTask.getId()) : changes.createArtifact(artType, jTask.getName());
                jTask.setId(taskArt.getId());
                IAtsTask task = this.atsApi.getWorkItemService().getTask(taskArt);
                this.atsApi.getWorkDefinitionService().setWorkDefinitionAttrs((IAtsWorkItem)task, this.taskWorkDef, changes);
                this.atsApi.getActionService().setAtsId((IAtsObject)task, teamWf.getTeamDefinition(), null, changes);
                changes.relate((Object)teamWf, AtsRelationTypes.TeamWfToTask_Task, (Object)taskArt);
                ArrayList<AtsUser> assignees = new ArrayList<AtsUser>();
                if (!jTask.getAssigneeUserIds().isEmpty()) {
                    assignees.addAll(this.atsApi.getUserService().getUsersByUserIds((Collection)jTask.getAssigneeUserIds()));
                }
                if (jTask.getAssigneeAccountIds() != null && !jTask.getAssigneeAccountIds().isEmpty()) {
                    for (ArtifactId assignArt : jTask.getAssigneeAccountIds()) {
                        assignees.add(this.atsApi.getUserService().getUserById(assignArt));
                    }
                }
                if (assignees.isEmpty()) {
                    assignees.add(AtsCoreUsers.UNASSIGNED_USER);
                }
                if (Strings.isValid((String)jTask.getDescription())) {
                    changes.setSoleAttributeValue((IAtsWorkItem)task, (AttributeTypeToken)AtsAttributeTypes.Description, jTask.getDescription());
                }
                AtsUser createdBy = this.atsApi.getUserService().getUserByUserId(jTask.getCreatedByUserId());
                this.atsApi.getActionService().initializeNewStateMachine((IAtsWorkItem)task, assignees, this.createdByDate, createdBy, this.taskWorkDef, changes);
                if (Strings.isValid((String)jTask.getRelatedToState())) {
                    changes.setSoleAttributeValue((IAtsWorkItem)task, (AttributeTypeToken)AtsAttributeTypes.RelatedToState, jTask.getRelatedToState());
                }
                if ((hoursSpent = jTask.getHoursSpent()) > 0.0) {
                    this.atsApi.getWorkItemMetricsService().setHoursSpentWorkflow((IAtsWorkItem)task, hoursSpent.doubleValue(), changes);
                }
                for (JaxAttribute attribute : jTask.getAttributes()) {
                    AttributeTypeToken attrType = attribute.getAttrType();
                    changes.setAttributeValues((IAtsObject)task, attrType, attribute.getValues());
                }
                for (JaxRelation relation : jTask.getRelations()) {
                    RelationTypeToken relationType = this.atsApi.tokenService().getRelationType(relation.getRelationTypeName());
                    Collection items = this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andIds(relation.getRelatedIds().toArray(new Long[relation.getRelatedIds().size()])).getItems();
                    RelationTypeSide side = null;
                    side = relation.isSideA() ? new RelationTypeSide(relationType, RelationSide.SIDE_A) : new RelationTypeSide(relationType, RelationSide.SIDE_B);
                    changes.setRelations((Object)task, side, items);
                }
                changes.add((Object)taskArt);
            }
        }
    }

    public static JaxAtsTask createNewJaxTask(Long id, AtsApi atsApi) {
        ArtifactReadable taskArt = (ArtifactReadable)atsApi.getQueryService().getArtifact(id);
        if (taskArt != null) {
            JaxAtsTask newJaxTask = new JaxAtsTask();
            newJaxTask.setName(taskArt.getName());
            newJaxTask.setDescription((String)taskArt.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.Description, (Object)""));
            newJaxTask.setId(taskArt.getId());
            newJaxTask.setActive(true);
            String createdByUserId = (String)taskArt.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.CreatedBy, null);
            newJaxTask.setCreatedByUserId(createdByUserId);
            newJaxTask.setCreatedDate((Date)taskArt.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.CreatedDate));
            newJaxTask.setRelatedToState((String)taskArt.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.RelatedToState, (Object)""));
            IAtsWorkItem workItem = atsApi.getWorkItemService().getWorkItem((ArtifactToken)taskArt);
            for (AtsUser user : workItem.getAssignees()) {
                newJaxTask.addAssigneeUserIds(user.getUserId());
            }
            for (AttributeTypeToken type : taskArt.getExistingAttributeTypes()) {
                LinkedList attributeValues = new LinkedList();
                for (Object value : taskArt.getAttributeValues(type)) {
                    attributeValues.add(value);
                }
                newJaxTask.addAttributes(type, attributeValues);
            }
            return newJaxTask;
        }
        return null;
    }

    public void setIdToTeamWf(Map<Long, IAtsTeamWorkflow> idToTeamWf) {
        for (Map.Entry<Long, IAtsTeamWorkflow> entry : idToTeamWf.entrySet()) {
            this.idToTeamWf.put(entry.getKey(), entry.getValue());
        }
    }
}

