/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.rule.validate;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.rule.validation.AbstractValidationRule;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class ListAndBulletRule
extends AbstractValidationRule {
    private static final Pattern NORMAL_LIST_BULLET_STYLE = Pattern.compile("<w:pPr><w:listPr>.+?</w:listPr></w:pPr>");
    private final WorkType workType;

    public ListAndBulletRule(WorkType workType, AtsApi atsApi) {
        super(atsApi);
        this.workType = workType;
    }

    public void validate(ArtifactToken artifact, XResultData rd) {
        String wtc = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)artifact, (AttributeTypeToken)CoreAttributeTypes.WordTemplateContent, (Object)"");
        Matcher match = NORMAL_LIST_BULLET_STYLE.matcher(wtc);
        if (match.find()) {
            String errStr = "is not using lists or bullets associated with an expected style.";
            this.logError(artifact, errStr, rd);
        }
    }

    public String getRuleDescription() {
        return "Ensure lists and bullets use an expected style in the artifact(s)";
    }

    public String getRuleTitle() {
        return String.format("Formatting Check for %s", this.workType);
    }
}

