/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.jdk.core.type.NamedBase;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

class WorkState
extends NamedBase {
    private final Pattern storagePattern = Pattern.compile("^(.*?);(.*?);(.*?);(.*?)$");
    private final Pattern userPattern = Pattern.compile("<(.*?)>");
    private final IAtsWorkItem workItem;
    private String name;
    private final Set<AtsUser> assignees = new HashSet<AtsUser>();
    private double hoursSpent = 0.0;
    private int percentComplete = 0;
    private IAttribute<Object> attr;
    private boolean loaded = false;
    private boolean currentState = false;

    private WorkState(IAtsWorkItem workItem, String name, Collection<AtsUser> assignees, double hoursSpent, int percentComplete, boolean currentState) {
        Conditions.assertNotNull(assignees, (String)"Assignees can't be null", (Object[])new Object[0]);
        this.workItem = workItem;
        this.name = name;
        this.assignees.addAll(assignees);
        this.assignees.remove(AtsCoreUsers.UNASSIGNED_USER);
        this.hoursSpent = hoursSpent;
        this.percentComplete = percentComplete;
        this.currentState = currentState;
    }

    public WorkState(IAtsWorkItem workItem, IAttribute<Object> attr, boolean currentState) {
        this.workItem = workItem;
        this.attr = attr;
        this.currentState = currentState;
    }

    public void setHoursSpent(double hoursSpent) {
        this.ensureLoaded();
        this.hoursSpent = hoursSpent;
    }

    public void setPercentComplete(int percentComplete) {
        this.ensureLoaded();
        this.percentComplete = percentComplete;
    }

    public String getName() {
        this.ensureLoaded();
        return this.name;
    }

    public Collection<AtsUser> getAssignees() {
        this.ensureLoaded();
        return this.assignees;
    }

    public double getHoursSpent() {
        return this.hoursSpent;
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public void addAssignee(AtsUser user) {
        Conditions.checkNotNull((Object)user, (String)"user");
        if (!user.equals((Object)AtsCoreUsers.UNASSIGNED_USER)) {
            this.assignees.add(user);
        }
    }

    public void setAssignees(Collection<AtsUser> users) {
        this.assignees.clear();
        for (AtsUser user : users) {
            if (user.equals((Object)AtsCoreUsers.UNASSIGNED_USER)) continue;
            this.addAssignee(user);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void removeAssignee(AtsUser assignee) {
        this.assignees.remove(assignee);
    }

    public void ensureLoaded() {
        if (!this.loaded) {
            this.fromStoreStr();
        }
    }

    public String getStoreStr() {
        if (!this.loaded && this.attr != null) {
            return (String)this.attr.getValue();
        }
        return String.format("%s;%s;;", this.name, AtsApiService.get().getUserService().getUserStorageString(this.assignees));
    }

    private void fromStoreStr() {
        String storeStr;
        if (this.attr != null && Strings.isValid((String)(storeStr = (String)this.attr.getValue()))) {
            Matcher m = this.storagePattern.matcher(storeStr);
            if (m.find()) {
                this.setName(m.group(1));
                if (!m.group(3).equals("")) {
                    this.hoursSpent = Float.valueOf(m.group(3)).doubleValue();
                }
                if (!m.group(4).equals("")) {
                    this.percentComplete = Integer.valueOf(m.group(4));
                }
            } else {
                throw new OseeArgumentException("Can't unpack state data [%s]", new Object[]{storeStr});
            }
            String userStr = m.group(2);
            List<AtsUser> users = this.getUsers(userStr);
            this.setAssignees(users);
            this.loaded = true;
        }
    }

    private List<AtsUser> getUsers(String storageString) {
        ArrayList<AtsUser> users = new ArrayList<AtsUser>();
        Matcher m = this.userPattern.matcher(storageString);
        while (m.find()) {
            String userId = m.group(1);
            if (!Strings.isValid((String)userId)) {
                throw new IllegalArgumentException("Blank userId specified.");
            }
            try {
                String uId = m.group(1);
                AtsUser u = this.workItem.getAtsApi().getUserService().getUserByUserId(uId);
                Conditions.checkNotNull((Object)u, (String)("userById " + uId));
                users.add(u);
            }
            catch (Exception ex) {
                OseeLog.log(WorkState.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return users;
    }

    public boolean isDirty() {
        String loaded;
        String stored;
        if (this.attr == null) {
            return true;
        }
        if (!this.loaded) {
            return false;
        }
        return this.attr != null && !(stored = (String)this.attr.getValue()).equals(loaded = this.getStoreStr());
    }

    public String toString() {
        return String.valueOf(this.getStoreStr()) + (this.loaded ? "" : " (unloaded)");
    }

    public static WorkState create(IAtsWorkItem workItem, String name, boolean currentState) {
        return new WorkState(workItem, name, Collections.emptyList(), 0.0, 0, currentState);
    }

    public static WorkState create(IAtsWorkItem workItem, String name, Collection<AtsUser> assignees, boolean currentState) {
        Conditions.checkNotNullOrContainNull(assignees, (String)"assignees");
        return new WorkState(workItem, name, assignees, 0.0, 0, currentState);
    }

    public static WorkState create(IAtsWorkItem workItem, IAttribute<Object> attr, boolean currentState) {
        return new WorkState(workItem, attr, currentState);
    }

    public boolean isCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(boolean currentState) {
        this.currentState = currentState;
    }

    public IAttribute<Object> getAttr() {
        return this.attr;
    }
}

