/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.util.IAtsStoreService;
import org.eclipse.osee.ats.core.config.WorkflowTypesTestOperation;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public abstract class AbstractAtsStoreService
implements IAtsStoreService {
    protected final AtsApi atsApi;

    public AbstractAtsStoreService(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public XResultData validateTypes() {
        WorkflowTypesTestOperation op = new WorkflowTypesTestOperation();
        return op.run();
    }

    public Collection<CustomizeData> getCustomizations(String namespace) {
        ArrayList<CustomizeData> customizations = new ArrayList<CustomizeData>();
        for (ArtifactId customizationArt : this.getCustomizeArts()) {
            this.addCustomizationsFromArts(namespace, customizations, customizationArt);
        }
        return customizations;
    }

    private void addCustomizationsFromArts(String namespace, List<CustomizeData> customizations, ArtifactId customizationArt) {
        for (String custXml : this.atsApi.getAttributeResolver().getAttributesToStringList(customizationArt, (AttributeTypeToken)CoreAttributeTypes.XViewerCustomization)) {
            if (!custXml.contains("\"" + namespace + "\"") && !custXml.contains("." + namespace + "\"")) continue;
            CustomizeData data = new CustomizeData(custXml);
            customizations.add(data);
        }
    }

    public Collection<CustomizeData> getCustomizationsGlobal(String namespace) {
        ArrayList<CustomizeData> customizations = new ArrayList<CustomizeData>();
        for (ArtifactId customizationArt : this.getGlobalCustomizeArts()) {
            this.addCustomizationsFromArts(namespace, customizations, customizationArt);
        }
        return customizations;
    }

    private List<ArtifactId> getCustomizeArts() {
        List<ArtifactId> customizationArts = this.getGlobalCustomizeArts();
        for (ArtifactId artifact : this.atsApi.getQueryService().getArtifacts(CoreArtifactTypes.User)) {
            customizationArts.add(artifact);
        }
        return customizationArts;
    }

    private List<ArtifactId> getGlobalCustomizeArts() {
        ArrayList<ArtifactId> customizationArts = new ArrayList<ArtifactId>();
        for (ArtifactId artifact : this.atsApi.getQueryService().getArtifacts(CoreArtifactTypes.XViewerGlobalCustomization)) {
            customizationArts.add(artifact);
        }
        return customizationArts;
    }
}

