/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsCoreAttrTokColumnToken;
import org.eclipse.osee.ats.api.column.AtsCoreColumn;
import org.eclipse.osee.ats.api.column.AtsCoreColumnToken;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.DisplayHint;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsCoreAttrTokenColumn
extends AtsCoreColumn {
    private final AtsCoreAttrTokColumnToken columnToken;
    private final String source;

    public AtsCoreAttrTokenColumn(AtsCoreAttrTokColumnToken columnToken, String source, AtsApi atsApi) {
        super((AtsCoreColumnToken)columnToken, atsApi);
        this.columnToken = columnToken;
        this.source = source;
    }

    public AtsCoreAttrTokenColumn(AttributeTypeToken attrType, String source, AtsApi atsApi) {
        this(new AtsCoreAttrTokColumnToken(attrType), source, atsApi);
    }

    public String getColumnText(IAtsObject atsObject) {
        return this.getColumnText(atsObject, this.columnToken.getAttrTypeId(), (boolean)this.isActionRollup(), (boolean)this.isInheritParent(), this.atsApi);
    }

    private Boolean isInheritParent() {
        Boolean inheritParent = this.columnToken.isInheritParent();
        return inheritParent == null ? false : inheritParent;
    }

    private Boolean isActionRollup() {
        Boolean actionRollup = this.columnToken.isActionRollup();
        return actionRollup == null ? false : actionRollup;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getColumnText(IAtsObject atsObject, long attrTypeId, boolean isActionRollup, boolean isInheritParent, AtsApi atsApi) {
        try {
            if (atsApi.getStoreService().isDeleted(atsObject)) {
                return "<deleted>";
            }
            if (atsObject instanceof IAtsWorkItem) {
                IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
                AttributeTypeGeneric attributeType = atsApi.tokenService().getAttributeType(Long.valueOf(attrTypeId));
                if (attributeType.getDisplayHints().contains(DisplayHint.YesNoBoolean) && atsApi.getAttributeResolver().isAttributeTypeValid((IAtsWorkItem)atsObject, (AttributeTypeToken)attributeType)) {
                    Boolean set = (Boolean)atsApi.getAttributeResolver().getSoleAttributeValue(atsObject, (AttributeTypeToken)attributeType, null);
                    if (set == null) {
                        return "";
                    }
                    if (set == false) return "No";
                    return "Yes";
                }
                String result = atsApi.getAttributeResolver().getAttributesToStringUniqueList((IAtsObject)workItem, (AttributeTypeToken)attributeType, ";");
                if (Strings.isValid((String)result)) {
                    return result;
                }
                if (isInheritParent && !workItem.isTeamWorkflow() && workItem.getParentTeamWorkflow() != null && Strings.isValid((String)(result = Collections.toString((String)"; ", (Object[])new Object[]{atsApi.getAttributeResolver().getAttributesToStringUniqueList((IAtsObject)workItem.getParentTeamWorkflow(), (AttributeTypeToken)attributeType, ";")})))) {
                    return result;
                }
            }
            if (!(atsObject instanceof IAtsAction)) return "";
            if (!isActionRollup) return "";
            Collection teams = ((IAtsAction)atsObject).getTeamWorkflows();
            HashSet<String> strs = new HashSet<String>();
            strs.add(atsObject.getName());
            Iterator iterator = teams.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return Collections.toString((String)"; ", strs);
                }
                IAtsTeamWorkflow team = (IAtsTeamWorkflow)iterator.next();
                String str = this.getColumnText((IAtsObject)team, attrTypeId, isActionRollup, isInheritParent, atsApi);
                if (!Strings.isValid((String)str)) continue;
                strs.add(str);
            }
        }
        catch (Exception ex) {
            return "!Error - " + ex.getLocalizedMessage();
        }
    }

    public String getColumnText(IAtsObject atsObject, AttributeTypeToken attributeType, boolean isActionRollup, boolean inheritParent, AtsApi atsApi) {
        return this.getColumnText(atsObject, attributeType.getId(), isActionRollup, inheritParent, atsApi);
    }

    public String toString() {
        return "AtsCoreAttrTokenColumn [attrType=" + this.columnToken.getAttrTypeName() + "]";
    }

    public AtsCoreAttrTokColumnToken getColumnToken() {
        return this.columnToken;
    }

    public String getSource() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " - " + this.source;
    }
}

