/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreCodeColumnToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.Priorities;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.core.column.model.AtsCoreCodeColumn;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;

public class PriorityColumn
extends AtsCoreCodeColumn {
    public PriorityColumn(AtsApi atsApi) {
        super((AtsCoreCodeColumnToken)AtsColumnTokensDefault.PriorityColumn, atsApi);
    }

    @Override
    public String getText(IAtsObject atsObject) {
        return PriorityColumn.getPriorityStr(atsObject);
    }

    public static String getPriorityStr(IAtsObject atsObject) {
        return (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue(atsObject, (AttributeTypeToken)AtsAttributeTypes.Priority, (Object)"");
    }

    public static String getPriorityStr(IAtsWorkItem workItem, AtsApi atsApi) {
        Priorities priority = PriorityColumn.getPriority(workItem, atsApi);
        if (priority == Priorities.None) {
            return "";
        }
        return priority.name();
    }

    public static Priorities getPriority(String priorityStr, AtsApi atsApi) {
        return Priorities.getPriority((Object)priorityStr);
    }

    public static Priorities getPriority(IAtsWorkItem workItem, AtsApi atsApi) {
        return Priorities.getPriority((Object)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.Priority, (Object)""));
    }

    public static Priorities getPriority(IAtsAction action, AtsApi atsApi) {
        return Priorities.getPriority((Object)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)action, (AttributeTypeToken)AtsAttributeTypes.Priority, (Object)""));
    }

    public static Priorities getPriority(IAtsObject atsObject, AtsApi atsApi) {
        Priorities priority = null;
        if (atsObject instanceof IAtsWorkItem) {
            priority = PriorityColumn.getPriority((IAtsWorkItem)atsObject.getStoreObject(), atsApi);
        } else if (atsObject instanceof IAtsAction) {
            priority = PriorityColumn.getPriority((IAtsAction)atsObject.getStoreObject(), atsApi);
        }
        return priority;
    }

    public static void setPriority(IAtsObject workItem, Priorities priority, IAtsChangeSet changes) {
        if (priority == null || priority == Priorities.None) {
            changes.deleteAttributes(workItem, (AttributeTypeToken)AtsAttributeTypes.Priority);
        } else {
            changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.Priority, (Object)priority.name());
        }
    }
}

