/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile;

import java.util.Date;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.AgileItem;
import org.eclipse.osee.ats.api.agile.AgileSprintData;
import org.eclipse.osee.ats.api.agile.IAgileItem;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreColumnToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.core.agile.SprintDataBuilder;
import org.eclipse.osee.ats.core.column.CompletedCancelledDateColumn;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class SprintUtil {
    public static String RGB_GREEN = "3, 127, 24";
    public static String RGB_BLACK = "0, 0, 0";
    public static String RGB_BLUE = "0, 4, 140";
    public static String RGB_YELLOW = "252, 252, 2";
    public static final String POINTS = "Points";
    public static final String DATES = "Dates";
    public static final String COMPLETED_UN_PLANNED = "Completed Un-Planned";
    public static final String COMPLETED_PLANNED = "Completed Planned";
    public static final String TOTAL_COMPLETED = "Total Completed";
    public static final String TOTAL_POINTS = "Total Points";
    public static final String TOTAL_REALIZED_POINTS = "Total Realized Points";
    public static final String REMAINING_WORK = "Remaining Work";
    public static final String TOTAL_WORK = "Total Work";

    private SprintUtil() {
    }

    public static AgileSprintData updateAgileSprintData(AtsApi atsApi, long teamId, long sprintId, AgileSprintData sprintData, XResultData results) {
        IAgileSprint sprint = atsApi.getAgileService().getAgileSprint(sprintId);
        if (sprint == null) {
            sprintData.getResults().errorf("Sprint can not be found with id %s", new Object[]{sprintId});
            return sprintData;
        }
        IAtsChangeSet changes = atsApi.createChangeSet("Update Agile Sprint Data");
        if (sprintData.getStartDate() != null) {
            Date startDate = null;
            try {
                startDate = sprintData.getStartDateAsDate();
                if (startDate != null) {
                    changes.setSoleAttributeValue((IAtsObject)sprint, (AttributeTypeToken)AtsAttributeTypes.StartDate, (Object)startDate);
                }
            }
            catch (Exception exception) {}
        }
        if (sprintData.getEndDate() != null) {
            Date endDate = null;
            try {
                endDate = sprintData.getEndDateAsDate();
                if (endDate != null) {
                    changes.setSoleAttributeValue((IAtsObject)sprint, (AttributeTypeToken)AtsAttributeTypes.EndDate, (Object)endDate);
                }
            }
            catch (Exception exception) {}
        }
        if (sprintData.getUnPlannedPoints() != null) {
            changes.setSoleAttributeValue((IAtsObject)sprint, (AttributeTypeToken)AtsAttributeTypes.UnplannedPoints, (Object)sprintData.getUnPlannedPoints());
        }
        if (sprintData.getPlannedPoints() != null) {
            changes.setSoleAttributeValue((IAtsObject)sprint, (AttributeTypeToken)AtsAttributeTypes.PlannedPoints, (Object)sprintData.getPlannedPoints());
        }
        changes.executeIfNeeded();
        return SprintUtil.getAgileSprintData(atsApi, teamId, sprintId, results);
    }

    public static AgileSprintData getAgileSprintData(AtsApi atsApi, long teamId, long sprintId, XResultData results) {
        IAgileTeam agileTeam;
        ArtifactToken sprintArt;
        if (teamId <= 0L) {
            results.errorf("teamId %s is not valid", new Object[]{teamId});
        }
        if (sprintId <= 0L) {
            results.errorf("sprintId %s is not valid", new Object[]{sprintId});
        }
        if ((sprintArt = atsApi.getQueryService().getArtifact(Long.valueOf(sprintId))) == null) {
            results.errorf("Sprint can not be found with id %s", new Object[]{sprintId});
        }
        if ((agileTeam = atsApi.getAgileService().getAgileTeam(teamId)) == null) {
            results.errorf("AgileTeam can not be found with id %s", new Object[]{teamId});
        }
        if (results.isErrors()) {
            return null;
        }
        IAgileSprint sprint = atsApi.getAgileService().getAgileSprint((ArtifactId)sprintArt);
        SprintDataBuilder builder = new SprintDataBuilder(agileTeam, sprint, atsApi, results);
        AgileSprintData sprintData = builder.get();
        return sprintData;
    }

    public static AgileItem getAgileItem(IAgileItem aItem, AtsApi atsApi) {
        AgileItem item = new AgileItem();
        IAtsWorkItem workItem = atsApi.getWorkItemService().getWorkItem(aItem.getStoreObject());
        item.setName(aItem.getName());
        item.setFeatureGroups(Collections.toString((String)"; ", (Iterable)atsApi.getAgileService().getFeatureGroups(aItem)));
        item.setId(aItem.getId());
        if (aItem.isCompletedOrCancelled()) {
            String implementers = atsApi.getImplementerService().getImplementersStr((IAtsObject)aItem);
            item.setImplementers(implementers);
            item.setAssigneesOrImplementers("(" + implementers + ")");
        } else {
            String assignees = Collections.toString((String)"; ", (Object[])new Object[]{aItem.getAssigneesStr()});
            item.setAssignees(assignees);
            item.setAssigneesOrImplementers(assignees);
        }
        item.setAtsId(workItem.getAtsId());
        item.setState(aItem.getCurrentStateName());
        item.setChangeType((String)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)aItem, (AttributeTypeToken)AtsAttributeTypes.ChangeType, (Object)""));
        item.setAgilePoints(atsApi.getAgileService().getAgileTeamPointsStr(workItem));
        IAtsVersion ver = atsApi.getVersionService().getTargetedVersion(workItem);
        item.setVersion(ver == null ? "" : ver.getName());
        Boolean unplanned = (Boolean)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)aItem, (AttributeTypeToken)AtsAttributeTypes.UnplannedWork, (Object)false);
        item.setUnPlannedWork(unplanned != false ? "U" : "");
        item.setNotes((String)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)aItem, (AttributeTypeToken)AtsAttributeTypes.WorkflowNotes, (Object)""));
        item.setCreateDate(atsApi.getColumnService().getColumnText((AtsCoreColumnToken)AtsColumnTokensDefault.CreatedDateColumn, (IAtsObject)workItem));
        item.setCompCancelDate(CompletedCancelledDateColumn.getCompletedCancelledDateStr(workItem));
        item.setLink("/ats/ui/action/" + item.getAtsId());
        return item;
    }
}

